/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;

public class CaseInsensitiveTable
implements ITable {
    private final ITable _table;

    public CaseInsensitiveTable(ITable table) {
        this._table = table;
    }

    private String getInternalColumnName(String columnName) throws DataSetException {
        Column[] columns = this._table.getTableMetaData().getColumns();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (columnName.equalsIgnoreCase(column.getColumnName())) {
                return column.getColumnName();
            }
            ++i;
        }
        throw new NoSuchColumnException(this._table.getTableMetaData().getTableName() + "." + columnName);
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        return this._table.getValue(row, this.getInternalColumnName(column));
    }
}

