/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.Arrays;
import java.util.Comparator;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;

public class SortedTable
extends AbstractTable {
    private final ITable _table;
    private final Column[] _columns;
    private Integer[] _indexes;

    public SortedTable(ITable table, Column[] columns) {
        this._table = table;
        this._columns = columns;
    }

    public SortedTable(ITable table, String[] columnNames) throws DataSetException {
        this._table = table;
        this._columns = new Column[columnNames.length];
        Column[] columns = table.getTableMetaData().getColumns();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            this._columns[i] = DataSetUtils.getColumn(columnName, columns);
            ++i;
        }
    }

    public SortedTable(ITable table, ITableMetaData metaData) throws DataSetException {
        this(table, metaData.getColumns());
    }

    public SortedTable(ITable table) throws DataSetException {
        this(table, table.getTableMetaData());
    }

    private int getOriginalRowIndex(int row) throws DataSetException {
        if (this._indexes == null) {
            Integer[] indexes = new Integer[this.getRowCount()];
            int i = 0;
            while (i < indexes.length) {
                indexes[i] = new Integer(i);
                ++i;
            }
            try {
                Arrays.sort(indexes, new RowComparator());
            }
            catch (DatabaseUnitRuntimeException e) {
                throw (DataSetException)e.getException();
            }
            this._indexes = indexes;
        }
        return this._indexes[row];
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        this.assertValidRowIndex(row);
        return this._table.getValue(this.getOriginalRowIndex(row), column);
    }

    private class RowComparator
    implements Comparator {
        private RowComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            try {
                int i = 0;
                while (i < SortedTable.this._columns.length) {
                    String columnName = SortedTable.this._columns[i].getColumnName();
                    Object value1 = SortedTable.this._table.getValue(i1, columnName);
                    Object value2 = SortedTable.this._table.getValue(i2, columnName);
                    if (value1 != null || value2 != null) {
                        String stringValue2;
                        if (value1 == null && value2 != null) {
                            return -1;
                        }
                        if (value1 != null && value2 == null) {
                            return 1;
                        }
                        String stringValue1 = DataType.asString(value1);
                        int result = stringValue1.compareTo(stringValue2 = DataType.asString(value2));
                        if (result != 0) {
                            return result;
                        }
                    }
                    ++i;
                }
            }
            catch (DataSetException e) {
                throw new DatabaseUnitRuntimeException(e);
            }
            return 0;
        }
    }
}

