/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public class CsvURLProducer
implements IDataSetProducer {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private URL base;
    private String tableList;

    public CsvURLProducer(URL base, String tableList) {
        this.base = base;
        this.tableList = tableList;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        this._consumer.startDataSet();
        try {
            List tableSpecs = CsvProducer.getTables(this.base, this.tableList);
            Iterator tableIter = tableSpecs.iterator();
            while (tableIter.hasNext()) {
                String table = (String)tableIter.next();
                try {
                    this.produceFromURL(new URL(this.base, table + ".csv"));
                }
                catch (CsvParserException e) {
                    throw new DataSetException("error producing dataset for table '" + table + "'", e);
                }
            }
            this._consumer.endDataSet();
        }
        catch (IOException e) {
            throw new DataSetException("error getting list of tables", e);
        }
    }

    private void produceFromURL(URL url) throws DataSetException {
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(url);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            int i = 0;
            while (i < readColumns.size()) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
                ++i;
            }
            String tableName = url.getFile();
            tableName = tableName.substring(tableName.lastIndexOf("/") + 1, tableName.indexOf(".csv"));
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this._consumer.startTable(metaData);
            int i2 = 1;
            while (i2 < readData.size()) {
                List rowList = (List)readData.get(i2);
                Object[] row = rowList.toArray();
                int col = 0;
                while (col < row.length) {
                    if ("null".equals(row[col])) {
                        row[col] = null;
                    }
                    ++col;
                }
                this._consumer.row(row);
                ++i2;
            }
            this._consumer.endTable();
        }
        catch (CsvParserException e) {
            throw new DataSetException("error parsing CSV for URL: '" + url + "'");
        }
        catch (IOException e) {
            throw new DataSetException("I/O error parsing CSV for URL: '" + url + "'");
        }
    }
}

