/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.Helper;
import org.dbunit.dataset.csv.handlers.Pipeline;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;

public abstract class AbstractPipelineComponent
implements PipelineComponent {
    private PipelineComponent successor;
    private Pipeline pipeline;
    private Helper helper;

    protected PipelineComponent getSuccessor() {
        return this.successor;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setSuccessor(PipelineComponent successor) {
        this.successor = successor;
    }

    private StringBuffer getThePiece() {
        return this.getPipeline().getCurrentProduct();
    }

    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        if (!this.canHandle(c)) {
            this.getSuccessor().handle(c);
        } else {
            this.getHelper().helpWith(c);
        }
    }

    public void noMoreInput() {
        if (this.allowForNoMoreInput() && this.getSuccessor() != null) {
            this.getSuccessor().noMoreInput();
        }
    }

    public boolean allowForNoMoreInput() {
        return this.getHelper().allowForNoMoreInput();
    }

    protected static PipelineComponent createPipelineComponent(AbstractPipelineComponent handler, Helper helper) {
        helper.setHandler(handler);
        handler.setHelper(helper);
        return handler;
    }

    public void accept(char c) {
        this.getThePiece().append(c);
    }

    protected Helper getHelper() {
        return this.helper;
    }

    private void setHelper(Helper helper) {
        this.helper = helper;
    }

    public abstract boolean canHandle(char var1) throws IllegalInputCharacterException;

    protected static class ACCEPT
    extends Helper {
        protected ACCEPT() {
        }

        public void helpWith(char c) {
            this.getHandler().accept(c);
        }
    }

    protected static class IGNORE
    extends Helper {
        protected IGNORE() {
        }

        public void helpWith(char c) {
        }
    }
}

