/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.excel.XlsTable;

public class XlsDataSet
extends AbstractDataSet {
    private final ITable[] _tables;

    public XlsDataSet(File file) throws IOException, DataSetException {
        this(new FileInputStream(file));
    }

    public XlsDataSet(InputStream in) throws IOException, DataSetException {
        HSSFWorkbook workbook = new HSSFWorkbook(in);
        this._tables = new ITable[workbook.getNumberOfSheets()];
        int i = 0;
        while (i < this._tables.length) {
            this._tables[i] = new XlsTable(workbook.getSheetName(i), workbook.getSheetAt(i));
            ++i;
        }
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        int index = 0;
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            ITable table = iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            HSSFSheet sheet = workbook.createSheet(metaData.getTableName());
            workbook.setSheetName(index, metaData.getTableName(), (short)1);
            HSSFRow headerRow = sheet.createRow(0);
            Column[] columns = metaData.getColumns();
            int j = 0;
            while (j < columns.length) {
                Column column = columns[j];
                HSSFCell cell = headerRow.createCell((short)j);
                cell.setEncoding((short)1);
                cell.setCellValue(column.getColumnName());
                ++j;
            }
            int j2 = 0;
            while (j2 < table.getRowCount()) {
                HSSFRow row = sheet.createRow(j2 + 1);
                int k = 0;
                while (k < columns.length) {
                    Column column = columns[k];
                    Object value = table.getValue(j2, column.getColumnName());
                    if (value != null) {
                        HSSFCell cell = row.createCell((short)k);
                        cell.setEncoding((short)1);
                        cell.setCellValue(DataType.asString(value));
                    }
                    ++k;
                }
                ++j2;
            }
            ++index;
        }
        workbook.write(out);
        out.flush();
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new DefaultTableIterator(this._tables, reversed);
    }
}

