/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.BitSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;

public class InsertOperation
extends AbstractBatchOperation {
    InsertOperation() {
    }

    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        Column[] columns = metaData.getColumns();
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("insert into ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        sqlBuffer.append(" (");
        String columnSeparator = "";
        int i = 0;
        while (i < columns.length) {
            if (!ignoreMapping.get(i)) {
                String columnName = this.getQualifiedName(null, columns[i].getColumnName(), connection);
                sqlBuffer.append(columnSeparator);
                sqlBuffer.append(columnName);
                columnSeparator = ", ";
            }
            ++i;
        }
        sqlBuffer.append(") values (");
        String valueSeparator = "";
        int i2 = 0;
        while (i2 < columns.length) {
            if (!ignoreMapping.get(i2)) {
                sqlBuffer.append(valueSeparator);
                sqlBuffer.append("?");
                valueSeparator = ", ";
            }
            ++i2;
        }
        sqlBuffer.append(")");
        return new OperationData(sqlBuffer.toString(), columns);
    }

    protected BitSet getIgnoreMapping(ITable table, int row) throws DataSetException {
        Column[] columns = table.getTableMetaData().getColumns();
        BitSet ignoreMapping = new BitSet();
        int i = 0;
        while (i < columns.length) {
            Object value = table.getValue(row, columns[i].getColumnName());
            if (value == ITable.NO_VALUE) {
                ignoreMapping.set(i);
            }
            ++i;
        }
        return ignoreMapping;
    }

    protected boolean equalsIgnoreMapping(BitSet ignoreMapping, ITable table, int row) throws DataSetException {
        Column[] columns = table.getTableMetaData().getColumns();
        int i = 0;
        while (i < columns.length) {
            boolean bit = ignoreMapping.get(i);
            Object value = table.getValue(row, columns[i].getColumnName());
            if (bit && value != ITable.NO_VALUE || !bit && value == ITable.NO_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

