/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.SynchronizedVariable;

public class SynchronizedInt
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected int value_;

    public SynchronizedInt(int initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedInt(int initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final int get() {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_;
            return n;
        }
    }

    public int set(int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            int old = this.value_;
            this.value_ = newValue;
            int n = old;
            return n;
        }
    }

    public boolean commit(int assumedValue, int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            return bl2;
        }
    }

    public int swap(SynchronizedInt other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedInt fst = this;
        SynchronizedInt snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                int n = this.get();
                return n;
            }
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            int n = ++this.value_;
            return n;
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            int n = --this.value_;
            return n;
        }
    }

    public int add(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_ += amount;
            return n;
        }
    }

    public int subtract(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_ -= amount;
            return n;
        }
    }

    public synchronized int multiply(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_ *= factor;
            return n;
        }
    }

    public int divide(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_ /= factor;
            return n;
        }
    }

    public int negate() {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.value_ = -this.value_;
            return n;
        }
    }

    public int complement() {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= 0xFFFFFFFF;
            int n = this.value_;
            return n;
        }
    }

    public int and(int b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ &= b;
            int n = this.value_;
            return n;
        }
    }

    public int or(int b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ |= b;
            int n = this.value_;
            return n;
        }
    }

    public int xor(int b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= b;
            int n = this.value_;
            return n;
        }
    }

    public int compareTo(int other) {
        int val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedInt other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedInt)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedInt) {
            return this.get() == ((SynchronizedInt)other).get();
        }
        return false;
    }

    public int hashCode() {
        return this.get();
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

