/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.BeiderMorseFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeiderMorseFilterFactory
extends BaseTokenFilterFactory {
    private PhoneticEngine engine;
    private Languages.LanguageSet languageSet;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String nameTypeArg = args.get("nameType");
        NameType nameType = nameTypeArg == null ? NameType.GENERIC : NameType.valueOf((String)nameTypeArg);
        String ruleTypeArg = args.get("ruleType");
        RuleType ruleType = ruleTypeArg == null ? RuleType.APPROX : RuleType.valueOf((String)ruleTypeArg);
        boolean concat = this.getBoolean("concat", true);
        this.engine = new PhoneticEngine(nameType, ruleType, concat);
        String languageSetArg = args.get("languageSet");
        this.languageSet = languageSetArg == null || languageSetArg.equals("auto") ? null : Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(languageSetArg.split(","))));
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new BeiderMorseFilter(input, this.engine, this.languageSet);
    }
}

