/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.FileFloatSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalFileField
extends FieldType {
    private FieldType ftype;
    private String keyFieldName;
    private IndexSchema schema;
    private float defVal;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(3072);
        String ftypeS = args.remove("valType");
        if (ftypeS != null) {
            this.ftype = schema.getFieldTypes().get(ftypeS);
            if (this.ftype != null && !(this.ftype instanceof FloatField) && !(this.ftype instanceof TrieFloatField)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Only float and pfloat (Trie|Float)Field are currently supported as external field type.  Got " + ftypeS);
            }
        }
        this.keyFieldName = args.remove("keyField");
        String defValS = args.remove("defVal");
        this.defVal = defValS == null ? 0.0f : Float.parseFloat(defValS);
        this.schema = schema;
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        SchemaField keyField = this.keyFieldName == null ? this.schema.getUniqueKeyField() : this.schema.getField(this.keyFieldName);
        return new FileFloatSource(field, keyField, this.defVal, parser);
    }
}

