/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class ReciprocalFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float m;
    protected final float a;
    protected final float b;

    public ReciprocalFloatFunction(ValueSource source, float m, float a, float b) {
        this.source = source;
        this.m = m;
        this.a = a;
        this.b = b;
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return ReciprocalFloatFunction.this.a / (ReciprocalFloatFunction.this.m * vals.floatVal(doc) + ReciprocalFloatFunction.this.b);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return Float.toString(ReciprocalFloatFunction.this.a) + "/(" + ReciprocalFloatFunction.this.m + "*float(" + vals.toString(doc) + ')' + '+' + ReciprocalFloatFunction.this.b + ')';
            }
        };
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    public String description() {
        return Float.toString(this.a) + "/(" + this.m + "*float(" + this.source.description() + ")" + "+" + this.b + ')';
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.a) + Float.floatToIntBits(this.m);
        h ^= h << 13 | h >>> 20;
        return h + Float.floatToIntBits(this.b) + this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (ReciprocalFloatFunction.class != o.getClass()) {
            return false;
        }
        ReciprocalFloatFunction other = (ReciprocalFloatFunction)o;
        return this.m == other.m && this.a == other.a && this.b == other.b && this.source.equals(other.source);
    }
}

