/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SolrServlet
extends HttpServlet {
    final Logger log = LoggerFactory.getLogger(SolrServlet.class);
    private boolean hasMulticore = false;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public void init() throws ServletException {
        this.log.info("SolrServlet.init()");
        String instanceDir = SolrResourceLoader.locateInstanceDir();
        File fconf = new File(instanceDir, "solr.xml");
        this.hasMulticore = fconf.exists();
        this.log.info("SolrServlet.init() done");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.hasMulticore) {
            response.sendError(400, "Missing solr core name in path");
            return;
        }
        SolrCore core = SolrCore.getSolrCore();
        SolrServletRequest solrReq = new SolrServletRequest(core, request);
        SolrQueryResponse solrRsp = new SolrQueryResponse();
        try {
            try {
                SolrRequestHandler handler = core.getRequestHandler(solrReq.getQueryType());
                if (handler == null) {
                    this.log.warn("Unknown Request Handler '" + solrReq.getQueryType() + "' :" + solrReq);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Request Handler '" + solrReq.getQueryType() + "'", true);
                }
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, solrRsp));
                core.execute(handler, solrReq, solrRsp);
                if (solrRsp.getException() == null) {
                    QueryResponseWriter responseWriter = core.getQueryResponseWriter(solrReq);
                    String ct = responseWriter.getContentType(solrReq, solrRsp);
                    if (null != ct) {
                        response.setContentType(ct);
                    }
                    if (responseWriter instanceof BinaryQueryResponseWriter) {
                        BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                        binWriter.write((OutputStream)response.getOutputStream(), (SolrQueryRequest)solrReq, solrRsp);
                    }
                    String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                    OutputStreamWriter out = charset == null || charset.equalsIgnoreCase("UTF-8") ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                    out = new FastWriter((Writer)out);
                    responseWriter.write(out, solrReq, solrRsp);
                    ((Writer)out).flush();
                }
                Exception e = solrRsp.getException();
                int rc = 500;
                if (e instanceof SolrException) {
                    rc = ((SolrException)((Object)e)).code();
                }
                this.sendErr(rc, SolrException.toStr((Throwable)e), request, response);
            }
            catch (SolrException e) {
                if (!e.logged) {
                    SolrException.log((Logger)this.log, (Throwable)e);
                }
                this.sendErr(e.code(), SolrException.toStr((Throwable)e), request, response);
                Object var12_17 = null;
                solrReq.close();
                SolrRequestInfo.clearRequestInfo();
                return;
            }
            catch (Throwable e) {
                SolrException.log((Logger)this.log, (Throwable)e);
                this.sendErr(500, SolrException.toStr((Throwable)e), request, response);
                Object var12_18 = null;
                solrReq.close();
                SolrRequestInfo.clearRequestInfo();
                return;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            solrReq.close();
            SolrRequestInfo.clearRequestInfo();
            throw throwable;
        }
        solrReq.close();
        SolrRequestInfo.clearRequestInfo();
    }

    final void sendErr(int rc, String msg, HttpServletRequest request, HttpServletResponse response) {
        try {
            try {
                response.setContentType("text/plain; charset=UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                response.setStatus(rc);
            }
            catch (Exception e) {
                // empty catch block
            }
            PrintWriter writer = response.getWriter();
            writer.write(msg);
        }
        catch (IOException e) {
            SolrException.log((Logger)this.log, (Throwable)e);
        }
    }
}

