/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmException;
import org.jbpm.command.AbstractProcessInstanceBaseCommand;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ChangeProcessInstanceVersionCommand
extends AbstractProcessInstanceBaseCommand {
    private static final long serialVersionUID = 2277080393930008224L;
    private static final Log log = LogFactory.getLog(ChangeProcessInstanceVersionCommand.class);
    private int newVersion = -1;
    private Map nodeNameMapping;
    private Map taskNameMapping;

    public ChangeProcessInstanceVersionCommand() {
    }

    public ChangeProcessInstanceVersionCommand(long processInstanceId, int newVersion) {
        super.setProcessInstanceId(processInstanceId);
        this.newVersion = newVersion;
    }

    public String getAdditionalToStringInformation() {
        return ";newVersion=" + this.newVersion;
    }

    private ProcessDefinition findNewProcessDefinition(String processName) {
        GraphSession graphSession = this.getJbpmContext().getGraphSession();
        return this.newVersion <= 0 ? graphSession.findLatestProcessDefinition(processName) : graphSession.findProcessDefinition(processName, this.newVersion);
    }

    public ProcessInstance execute(ProcessInstance pi) {
        ProcessDefinition oldDef = pi.getProcessDefinition();
        ProcessDefinition newDef = this.findNewProcessDefinition(oldDef.getName());
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("migrating " + pi + " from version " + oldDef.getVersion() + " to " + newDef.getVersion()));
        }
        pi.setProcessDefinition(newDef);
        this.changeTokenVersion(pi.getRootToken());
        if (debug) {
            log.debug((Object)(pi + " migrated to version " + newDef.getVersion()));
        }
        return pi;
    }

    private void changeTokenVersion(Token token) {
        Node oldNode = token.getNode();
        ProcessDefinition newDef = token.getProcessInstance().getProcessDefinition();
        Node newNode = this.findReplacementNode(newDef, oldNode);
        token.setNode(newNode);
        this.adjustTimersForToken(token);
        this.adjustTaskInstancesForToken(token);
        Map children = token.getChildren();
        if (children != null) {
            Iterator i = children.values().iterator();
            while (i.hasNext()) {
                this.changeTokenVersion((Token)i.next());
            }
        }
    }

    private void adjustTaskInstancesForToken(Token token) {
        ProcessDefinition newDef = token.getProcessInstance().getProcessDefinition();
        boolean debug = log.isDebugEnabled();
        for (TaskInstance ti : this.getTasksForToken(token)) {
            Task oldTask = ti.getTask();
            TaskNode oldNode = oldTask.getTaskNode();
            Task newTask = this.findReplacementTask(newDef, oldNode, oldTask);
            ti.setTask(newTask);
            if (!debug) continue;
            log.debug((Object)("adjusted " + ti));
        }
    }

    private void adjustTimersForToken(Token token) {
        ProcessDefinition newDef = token.getProcessInstance().getProcessDefinition();
        List jobs = this.getJbpmContext().getJobSession().findJobsByToken(token);
        for (Job job : jobs) {
            Timer timer;
            if (!(job instanceof Timer) || (timer = (Timer)job).getGraphElement() == null) continue;
            if (timer.getGraphElement() instanceof Task) {
                Task oldTask = (Task)timer.getGraphElement();
                TaskNode oldNode = oldTask.getTaskNode();
                timer.setGraphElement(this.findReplacementTask(newDef, oldNode, oldTask));
                continue;
            }
            GraphElement oldNode = timer.getGraphElement();
            timer.setGraphElement(this.findReplacementNode(newDef, oldNode));
        }
    }

    private Node findReplacementNode(ProcessDefinition newDef, GraphElement oldNode) {
        String name = this.getReplacementNodeName(oldNode);
        Node newNode = newDef.findNode(name);
        if (newNode == null) {
            throw new JbpmException("could not find node '" + name + "' in " + newDef);
        }
        return newNode;
    }

    private Task findReplacementTask(ProcessDefinition newDef, Node oldNode, Task oldTask) {
        String newTaskName;
        Node newNode = this.findReplacementNode(newDef, oldNode);
        if (newNode.getNodeType() != Node.NodeType.Task) {
            throw new JbpmException("expected" + newNode + " to be a task node");
        }
        TaskNode newTaskNode = newNode instanceof TaskNode ? (TaskNode)newNode : (TaskNode)this.getJbpmContext().getSession().load(TaskNode.class, (Serializable)new Long(newNode.getId()));
        Task newTask = newTaskNode.getTask(newTaskName = this.getReplacementTaskName(oldTask));
        if (newTask == null) {
            throw new JbpmException("could not find task '" + newTaskName + "' for node '" + newTaskNode.getName() + "' in " + newDef);
        }
        return newTask;
    }

    private String getReplacementNodeName(GraphElement oldNode) {
        String oldName;
        String string = oldName = oldNode instanceof Node ? ((Node)oldNode).getFullyQualifiedName() : oldNode.getName();
        if (this.nodeNameMapping != null && this.nodeNameMapping.containsKey(oldName)) {
            return (String)this.nodeNameMapping.get(oldName);
        }
        return oldName;
    }

    private String getReplacementTaskName(Task oldTask) {
        String oldName = oldTask.getName();
        if (this.taskNameMapping != null && this.taskNameMapping.containsKey(oldName)) {
            return (String)this.taskNameMapping.get(oldName);
        }
        return oldName;
    }

    private List getTasksForToken(Token token) {
        Query query = this.getJbpmContext().getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
        query.setLong("tokenId", token.getId());
        return query.list();
    }

    public Map getNodeNameMapping() {
        return this.nodeNameMapping;
    }

    public void setNodeNameMapping(Map nameMapping) {
        this.nodeNameMapping = nameMapping;
    }

    public int getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(int newVersion) {
        this.newVersion = newVersion;
    }

    public Map getTaskNameMapping() {
        return this.taskNameMapping;
    }

    public void setTaskNameMapping(Map nameMapping) {
        this.taskNameMapping = nameMapping;
    }

    public long getProcessId() {
        if (this.getProcessInstanceIds() != null && this.getProcessInstanceIds().length > 0) {
            return this.getProcessInstanceIds()[0];
        }
        return 0L;
    }

    public void setProcessId(long processId) {
        super.setProcessInstanceId(processId);
    }

    public Map getNameMapping() {
        return this.getNodeNameMapping();
    }

    public void setNameMapping(Map nameMapping) {
        this.setNodeNameMapping(nameMapping);
    }

    public ChangeProcessInstanceVersionCommand nodeNameMapping(Map nameMapping) {
        this.setNodeNameMapping(nameMapping);
        return this;
    }

    public ChangeProcessInstanceVersionCommand newVersion(int newVersion) {
        this.setNewVersion(newVersion);
        return this;
    }

    public ChangeProcessInstanceVersionCommand taskNameMapping(Map nameMapping) {
        this.setTaskNameMapping(nameMapping);
        return this;
    }

    public ChangeProcessInstanceVersionCommand nodeNameMappingAdd(String oldNodeName, String newNodeName) {
        if (this.nodeNameMapping == null) {
            this.nodeNameMapping = new HashMap();
        }
        this.nodeNameMapping.put(oldNodeName, newNodeName);
        return this;
    }

    public ChangeProcessInstanceVersionCommand taskNameMappingAdd(String oldTaskName, String newNodeName) {
        if (this.taskNameMapping == null) {
            this.taskNameMapping = new HashMap();
        }
        this.taskNameMapping.put(oldTaskName, newNodeName);
        return this;
    }
}

