/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JbpmSession;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.JndiUtil;

public class JbpmSessionFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String jndiName = JbpmSessionFactory.getJndiName();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private Collection hibernatableLongIdClasses;
    private Collection hibernatableStringIdClasses;
    private JbpmSchema jbpmSchema;
    private static JbpmSessionFactory instance;
    private static final Log log;

    private static String getJndiName() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.session.factory.jndi.name")) {
            return JbpmConfiguration.Configs.getString("jbpm.session.factory.jndi.name");
        }
        return null;
    }

    public static JbpmSessionFactory getInstance() {
        if (instance == null) {
            if (jndiName != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fetching JbpmSessionFactory from " + jndiName));
                }
                instance = (JbpmSessionFactory)JndiUtil.lookup(jndiName, JbpmSessionFactory.class);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"building singleton JbpmSessionFactory");
                }
                instance = JbpmSessionFactory.buildJbpmSessionFactory();
            }
        }
        return instance;
    }

    public JbpmSessionFactory(Configuration configuration) {
        this(configuration, JbpmSessionFactory.buildSessionFactory(configuration));
    }

    public JbpmSessionFactory(Configuration configuration, SessionFactory sessionFactory) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
    }

    public static JbpmSessionFactory buildJbpmSessionFactory() {
        return JbpmSessionFactory.buildJbpmSessionFactory(JbpmSessionFactory.getConfigResource());
    }

    public static JbpmSessionFactory buildJbpmSessionFactory(String configResource) {
        return JbpmSessionFactory.buildJbpmSessionFactory(JbpmSessionFactory.createConfiguration(configResource));
    }

    public static JbpmSessionFactory buildJbpmSessionFactory(Configuration configuration) {
        return new JbpmSessionFactory(configuration);
    }

    private static String getConfigResource() {
        return JbpmConfiguration.Configs.getString("resource.hibernate.cfg.xml");
    }

    public static Configuration createConfiguration() {
        return JbpmSessionFactory.createConfiguration(JbpmSessionFactory.getConfigResource());
    }

    public static Configuration createConfiguration(String configResource) {
        Configuration configuration = new Configuration();
        if (configResource != null) {
            configuration.configure(configResource);
        } else {
            configuration.configure();
        }
        if (JbpmConfiguration.Configs.hasObject("resource.hibernate.properties")) {
            String propertiesResource = JbpmConfiguration.Configs.getString("resource.hibernate.properties");
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading hibernate properties from resource: " + propertiesResource));
            }
            Properties properties = new Properties();
            try {
                properties.load(ClassLoaderUtil.getStream(propertiesResource));
            }
            catch (IOException e) {
                throw new JbpmException("could not load hibernate properties from resource: " + propertiesResource, e);
            }
            configuration.addProperties(properties);
        }
        return configuration;
    }

    public static SessionFactory buildSessionFactory(Configuration configuration) {
        return configuration.buildSessionFactory();
    }

    public JbpmSession openJbpmSession() {
        return this.openJbpmSession(null);
    }

    public JbpmSession openJbpmSession(Connection jdbcConnection) {
        JbpmSession dbSession;
        try {
            Session session = null;
            if (jdbcConnection != null) {
                throw new JbpmException("Unsupported operation");
            }
            session = this.getSessionFactory().openSession();
            dbSession = new JbpmSession(this, session);
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("couldn't create a hibernate persistence session", e);
        }
        return dbSession;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isHibernatableWithLongId(Class clazz) {
        if (this.hibernatableLongIdClasses == null) {
            this.initHibernatableClasses();
        }
        return this.hibernatableLongIdClasses.contains(clazz);
    }

    public boolean isHibernatableWithStringId(Class clazz) {
        if (this.hibernatableStringIdClasses == null) {
            this.initHibernatableClasses();
        }
        return this.hibernatableStringIdClasses.contains(clazz);
    }

    public JbpmSchema getJbpmSchema() {
        if (this.jbpmSchema == null) {
            this.jbpmSchema = new JbpmSchema(this.configuration);
        }
        return this.jbpmSchema;
    }

    private void initHibernatableClasses() {
        this.hibernatableLongIdClasses = new HashSet();
        this.hibernatableStringIdClasses = new HashSet();
        Iterator iter = this.configuration.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)iter.next();
            if (LongType.class == persistentClass.getIdentifier().getType().getClass()) {
                this.hibernatableLongIdClasses.add(persistentClass.getMappedClass());
                continue;
            }
            if (StringType.class != persistentClass.getIdentifier().getType().getClass()) continue;
            this.hibernatableStringIdClasses.add(persistentClass.getMappedClass());
        }
    }

    static {
        log = LogFactory.getLog(JbpmSessionFactory.class);
    }
}

