/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.util.ClassLoaderUtil;

public class HibernateHelper {
    private static Map configurations = new HashMap();
    private static final Log log = LogFactory.getLog(HibernateHelper.class);

    private HibernateHelper() {
    }

    public static void clearConfigurationsCache() {
        configurations.clear();
    }

    public static SessionFactory createSessionFactory() {
        return HibernateHelper.createSessionFactory(null, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, propertiesResource, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource, boolean isConfigLookupEnabled) {
        Configuration configuration = HibernateHelper.createConfiguration(cfgXmlResource, propertiesResource);
        return HibernateHelper.createSessionFactory(configuration, isConfigLookupEnabled);
    }

    public static SessionFactory createSessionFactory(Configuration configuration, boolean isConfigLookupEnabled) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        if (isConfigLookupEnabled) {
            configurations.put(sessionFactory, configuration);
        }
        return sessionFactory;
    }

    public static Configuration createConfiguration(String cfgXmlResource, String propertiesResource) {
        Configuration configuration = new Configuration();
        if (cfgXmlResource != null) {
            configuration.configure(cfgXmlResource);
        } else {
            configuration.configure();
        }
        if (propertiesResource != null) {
            Properties properties;
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading hibernate properties from resource: " + propertiesResource));
            }
            if (!(properties = HibernateHelper.loadPropertiesFromResource(propertiesResource)).isEmpty()) {
                configuration.addProperties(properties);
            }
        }
        return configuration;
    }

    public static Configuration getConfiguration(SessionFactory sessionFactory) {
        return (Configuration)configurations.get(sessionFactory);
    }

    public static SchemaExport createSchemaExport(SessionFactory sessionFactory) {
        return new SchemaExport(HibernateHelper.getConfiguration(sessionFactory));
    }

    public static boolean createSchemaExportScript(SessionFactory sessionFactory) {
        String showSql = HibernateHelper.getConfiguration(sessionFactory).getProperty("hibernate.show_sql");
        return "true".equalsIgnoreCase(showSql);
    }

    public static void clearHibernateCache(SessionFactory sessionFactory) {
        sessionFactory.evictQueries();
        Map classMetadata = sessionFactory.getAllClassMetadata();
        for (String entityName : classMetadata.keySet()) {
            sessionFactory.evictEntity(entityName);
        }
        Map collectionMetadata = sessionFactory.getAllCollectionMetadata();
        for (String collectionName : collectionMetadata.keySet()) {
            sessionFactory.evictCollection(collectionName);
        }
    }

    private static Properties loadPropertiesFromResource(String resource) {
        Properties properties = new Properties();
        InputStream inputStream = ClassLoaderUtil.getStream(resource);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                log.warn((Object)("could not load hibernate properties from resource: " + resource), (Throwable)e);
            }
        } else {
            log.warn((Object)("hibernate properties resource not found: " + resource));
        }
        return properties;
    }
}

