/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.type.TextType;
import org.hibernate.usertype.ParameterizedType;

public class LimitedTextType
extends TextType
implements ParameterizedType {
    private int limit;
    private static final long serialVersionUID = 1L;

    public int getLimit() {
        return this.limit;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        String text = (String)value;
        int length = text.length();
        if (length > this.limit) {
            text = text.substring(0, this.limit);
            length = this.limit;
        }
        st.setCharacterStream(index, (Reader)new StringReader(text), length);
    }

    public void setParameterValues(Properties parameters) {
        this.limit = Integer.parseInt(parameters.getProperty("limit"));
    }
}

