/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.JpdlException;

public class DbSubProcessResolver
implements SubProcessResolver {
    private static final long serialVersionUID = 1L;

    public ProcessDefinition findSubProcess(Element subProcessElement) {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            String subProcessName = subProcessElement.attributeValue("name");
            if (subProcessName == null) {
                throw new JpdlException("missing sub-process name");
            }
            String subProcessVersion = subProcessElement.attributeValue("version");
            if (subProcessVersion == null) {
                return jbpmContext.getGraphSession().findLatestProcessDefinition(subProcessName);
            }
            try {
                int version = Integer.parseInt(subProcessVersion);
                return jbpmContext.getGraphSession().findProcessDefinition(subProcessName, version);
            }
            catch (NumberFormatException e) {
                throw new JpdlException("bad sub-process version value: " + subProcessVersion);
            }
        }
        return null;
    }
}

