/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.ProcessClassLoader;
import org.jbpm.instantiation.ProcessClassLoaderFactory;
import org.jbpm.util.ClassLoaderUtil;

public class SharedProcessClassLoaderFactory
implements ProcessClassLoaderFactory {
    private JbpmConfiguration jbpmConfiguration;
    private transient Map classLoaderRefs = new HashMap();
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        long id = processDefinition.getId();
        Long key = new Long(id == 0L ? (long)processDefinition.hashCode() : id);
        ClassLoader parentClassLoader = ClassLoaderUtil.getClassLoader();
        Map map = this.classLoaderRefs;
        synchronized (map) {
            ClassLoader processClassLoader = this.getProcessClassLoader(key, parentClassLoader);
            if (processClassLoader == null) {
                processClassLoader = new ProcessClassLoader(parentClassLoader, processDefinition, this.jbpmConfiguration);
                this.putProcessClassLoader(key, processClassLoader);
            }
            return processClassLoader;
        }
    }

    private ClassLoader getProcessClassLoader(Long processDefinitionKey, ClassLoader parentClassLoader) {
        List referenceList = (List)this.classLoaderRefs.get(processDefinitionKey);
        if (referenceList != null) {
            Iterator i = referenceList.iterator();
            while (i.hasNext()) {
                SoftReference reference = (SoftReference)i.next();
                ClassLoader processClassLoader = (ClassLoader)reference.get();
                if (processClassLoader == null) {
                    i.remove();
                    continue;
                }
                if (processClassLoader.getParent() != parentClassLoader) continue;
                return processClassLoader;
            }
        }
        return null;
    }

    private void putProcessClassLoader(Long processDefinitionKey, ClassLoader processClassLoader) {
        ArrayList<SoftReference<ClassLoader>> referenceList = (ArrayList<SoftReference<ClassLoader>>)this.classLoaderRefs.get(processDefinitionKey);
        if (referenceList == null) {
            referenceList = new ArrayList<SoftReference<ClassLoader>>();
            this.classLoaderRefs.put(processDefinitionKey, referenceList);
        }
        referenceList.add(new SoftReference<ClassLoader>(processClassLoader));
    }
}

