/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jcr.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jbpm.JbpmException;
import org.jbpm.jcr.JcrService;
import org.jbpm.svc.Services;
import org.jbpm.tx.TxService;

public class JcrServiceImpl
implements JcrService {
    private static final long serialVersionUID = 1L;
    protected Session session;

    public JcrServiceImpl(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void close() {
        TxService txService = JcrServiceImpl.getTxService();
        if (txService != null && txService.isRollbackOnly()) {
            try {
                this.session.refresh(false);
            }
            catch (RepositoryException e) {
                throw new JbpmException("could not refresh(rollback) jcr session", e);
            }
        }
        try {
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new JbpmException("could not save jcr session", e);
        }
        this.session.logout();
    }

    private static TxService getTxService() {
        return (TxService)Services.getCurrentService("tx");
    }
}

