/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String getSimpleName(Class clazz) {
        int index;
        if (clazz.isArray()) {
            return ClassUtil.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String simpleName = ClassUtil.getSimpleBinaryName(clazz);
        if (simpleName == null) {
            simpleName = clazz.getName();
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        int length = simpleName.length();
        if (length < 1 || simpleName.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (index = 1; index < length && ClassUtil.isAsciiDigit(simpleName.charAt(index)); ++index) {
        }
        return simpleName.substring(index);
    }

    private static String getSimpleBinaryName(Class clazz) {
        Class<?> enclosingClass = clazz.getDeclaringClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return clazz.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name");
        }
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }
}

