/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.Serializable;

public class Semaphore
implements Serializable {
    private int permits;
    private static final long serialVersionUID = 1L;

    public Semaphore(int permits) {
        this.permits = permits;
    }

    public void release() {
        this.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException(Integer.toString(permits));
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            this.permits += permits;
            this.notifyAll();
        }
    }

    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(int permits) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException(Integer.toString(permits));
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            while (this.permits < permits) {
                this.wait();
            }
            this.permits -= permits;
        }
    }

    public boolean tryAcquire(long timeout) throws InterruptedException {
        return this.tryAcquire(1, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int permits, long timeout) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException(Integer.toString(permits));
        }
        long startTime = System.currentTimeMillis();
        Semaphore semaphore = this;
        synchronized (semaphore) {
            while (this.permits < permits) {
                if (System.currentTimeMillis() - startTime >= timeout) {
                    return false;
                }
                this.wait(timeout);
            }
            this.permits -= permits;
            return true;
        }
    }

    public synchronized int drainPermits() {
        int permits = this.permits;
        this.permits = 0;
        return permits;
    }
}

