/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import [Ljava.lang.Object;;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.TripleKeyHashMap;
import org.codehaus.groovy.reflection.WeakDoubleKeyHashMap;

public class ReflectionCache {
    private static Map primitiveTypesMap = new HashMap();
    static TripleKeyHashMap mopNames;
    static final Map CACHED_CLASS_MAP;
    static WeakDoubleKeyHashMap assignableMap;
    private static final CachedClass STRING_CLASS;
    public static final CachedClass OBJECT_CLASS;
    public static final CachedClass OBJECT_ARRAY_CLASS;

    public static Class autoboxType(Class type) {
        Class res = (Class)primitiveTypesMap.get(type);
        return res == null ? type : res;
    }

    public static String getMOPMethodName(CachedClass declaringClass, String name, boolean useThis) {
        TripleKeyHashMap.Entry mopNameEntry = mopNames.getOrPut(declaringClass, name, useThis);
        if (mopNameEntry.value == null) {
            mopNameEntry.value = (useThis ? "this$" : "super$") + declaringClass.getSuperClassDistance() + "$" + name;
        }
        return (String)mopNameEntry.value;
    }

    public static boolean isArray(Class klazz) {
        return klazz.getName().charAt(0) == '[';
    }

    static void setAssignableFrom(Class klazz, Class aClass) {
        WeakDoubleKeyHashMap.Entry val = assignableMap.getOrPut(klazz, aClass);
        if (val.value == null) {
            val.value = Boolean.TRUE;
        }
    }

    public static boolean isAssignableFrom(Class klazz, Class aClass) {
        if (klazz == aClass) {
            return true;
        }
        WeakDoubleKeyHashMap.Entry val = assignableMap.getOrPut(klazz, aClass);
        if (val.value == null) {
            val.value = klazz.isAssignableFrom(aClass);
        }
        return (Boolean)val.value;
    }

    static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedClass getCachedClass(Class klazz) {
        CachedClass cachedClass;
        if (klazz == null) {
            return null;
        }
        if (klazz == Object.class) {
            return OBJECT_CLASS;
        }
        if (klazz == String.class) {
            return STRING_CLASS;
        }
        Map map = CACHED_CLASS_MAP;
        synchronized (map) {
            SoftReference ref = (SoftReference)CACHED_CLASS_MAP.get(klazz);
            if (ref == null || (cachedClass = (CachedClass)ref.get()) == null) {
                cachedClass = Number.class.isAssignableFrom(klazz) || klazz.isPrimitive() ? (klazz == Number.class ? new CachedClass.NumberCachedClass(klazz) : (klazz == Integer.class || klazz == Integer.TYPE ? new CachedClass.IntegerCachedClass(klazz) : (klazz == Double.class || klazz == Double.TYPE ? new CachedClass.DoubleCachedClass(klazz) : (klazz == BigDecimal.class ? new CachedClass.BigDecimalCachedClass(klazz) : (klazz == Long.class || klazz == Long.TYPE ? new CachedClass.LongCachedClass(klazz) : (klazz == Float.class || klazz == Float.TYPE ? new CachedClass.FloatCachedClass(klazz) : (klazz == Short.class || klazz == Short.TYPE ? new CachedClass.ShortCachedClass(klazz) : (klazz == Boolean.TYPE ? new CachedClass.BooleanCachedClass(klazz) : (klazz == Character.TYPE ? new CachedClass.CharacterCachedClass(klazz) : (klazz == BigInteger.class ? new CachedClass.BigIntegerCachedClass(klazz) : (klazz == Byte.class ? new CachedClass.ByteCachedClass(klazz) : new CachedClass(klazz)))))))))))) : (klazz.getName().charAt(0) == '[' ? new CachedClass.ArrayCachedClass(klazz) : (klazz == Boolean.class ? new CachedClass.BooleanCachedClass(klazz) : (klazz == Character.class ? new CachedClass.CharacterCachedClass(klazz) : new CachedClass(klazz))));
                CACHED_CLASS_MAP.put(klazz, new SoftReference<CachedClass>(cachedClass));
            }
        }
        return cachedClass;
    }

    static {
        primitiveTypesMap.put(Byte.TYPE, Byte.class);
        primitiveTypesMap.put(Boolean.TYPE, Boolean.class);
        primitiveTypesMap.put(Character.TYPE, Character.class);
        primitiveTypesMap.put(Double.TYPE, Double.class);
        primitiveTypesMap.put(Float.TYPE, Float.class);
        primitiveTypesMap.put(Integer.TYPE, Integer.class);
        primitiveTypesMap.put(Long.TYPE, Long.class);
        primitiveTypesMap.put(Short.TYPE, Short.class);
        mopNames = new TripleKeyHashMap();
        CACHED_CLASS_MAP = new WeakHashMap();
        assignableMap = new WeakDoubleKeyHashMap();
        STRING_CLASS = new CachedClass.StringCachedClass();
        OBJECT_CLASS = new CachedClass(Object.class){

            public synchronized CachedClass getCachedSuperClass() {
                return null;
            }

            public boolean isAssignableFrom(Class argument) {
                return true;
            }
        };
        OBJECT_ARRAY_CLASS = ReflectionCache.getCachedClass(Object;.class);
    }
}

