/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
import org.jboss.metadata.ear.spec.EjbModuleMetaData;
import org.jboss.metadata.ear.spec.JavaModuleMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.parser.spec.Attribute;
import org.jboss.metadata.parser.spec.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class EarModuleMetaDataParser
extends MetaDataElementParser {
    public static ModuleMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ModuleMetaData moduleMetaData = new ModuleMetaData();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (EarModuleMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    moduleMetaData.setId(value);
                    continue block10;
                }
                default: {
                    throw EarModuleMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    moduleMetaData.setValue(EarModuleMetaDataParser.parseConnector(reader));
                    continue block11;
                }
                case EJB: {
                    moduleMetaData.setValue(EarModuleMetaDataParser.parseEjb(reader));
                    continue block11;
                }
                case JAVA: {
                    moduleMetaData.setValue(EarModuleMetaDataParser.parseJava(reader));
                    continue block11;
                }
                case WEB: {
                    moduleMetaData.setValue(EarModuleMetaDataParser.parseWeb(reader));
                    continue block11;
                }
                case ALT_DD: {
                    moduleMetaData.setAlternativeDD(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block11;
                }
            }
            throw EarModuleMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return moduleMetaData;
    }

    private static ConnectorModuleMetaData parseConnector(XMLStreamReader reader) throws XMLStreamException {
        ConnectorModuleMetaData module = new ConnectorModuleMetaData();
        module.setFileName(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
        return module;
    }

    private static EjbModuleMetaData parseEjb(XMLStreamReader reader) throws XMLStreamException {
        EjbModuleMetaData module = new EjbModuleMetaData();
        module.setFileName(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
        return module;
    }

    private static JavaModuleMetaData parseJava(XMLStreamReader reader) throws XMLStreamException {
        JavaModuleMetaData module = new JavaModuleMetaData();
        module.setFileName(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
        return module;
    }

    private static WebModuleMetaData parseWeb(XMLStreamReader reader) throws XMLStreamException {
        WebModuleMetaData webModuleMetaData = new WebModuleMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (EarModuleMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    webModuleMetaData.setId(value);
                    continue block7;
                }
                default: {
                    throw EarModuleMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_ROOT: {
                    webModuleMetaData.setContextRoot(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block8;
                }
                case WEB_URI: {
                    webModuleMetaData.setWebURI(EarModuleMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block8;
                }
            }
            throw EarModuleMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return webModuleMetaData;
    }
}

