/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class GrantRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public GrantRoleConstantAction(List list, List list2) {
        this.roleNames = list;
        this.grantees = list2;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        String string = languageConnectionContext.getAuthorizationId();
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = this.roleNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Iterator iterator2 = this.grantees.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                RoleDescriptor roleDescriptor = dataDictionary.getRoleDefinitionDescriptor(string2);
                if (roleDescriptor == null) {
                    throw StandardException.newException("0P000", string2);
                }
                if (!string.equals(roleDescriptor.getGrantee())) {
                    throw StandardException.newException("4251A", "GRANT role");
                }
                roleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string3, string);
                if (roleDescriptor != null) {
                    // empty if block
                }
                if (roleDescriptor != null) continue;
                RoleDescriptor roleDescriptor2 = dataDictionary.getRoleDefinitionDescriptor(string3);
                if (roleDescriptor2 != null) {
                    // empty if block
                }
                roleDescriptor = dataDescriptorGenerator.newRoleDescriptor(dataDictionary.getUUIDFactory().createUUID(), string2, string3, string, false, false);
                dataDictionary.addDescriptor(roleDescriptor, null, 19, false, transactionController);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.roleNames.iterator();
        while (object.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object.next().toString());
        }
        object = new StringBuffer();
        Iterator iterator = this.grantees.iterator();
        while (iterator.hasNext()) {
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(iterator.next().toString());
        }
        return "GRANT " + stringBuffer.toString() + " TO: " + ((StringBuffer)object).toString() + "\n";
    }
}

