/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.security.SimpleUserInfo;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

public class RealmSecurityProvider
implements RemotingSecurityProvider {
    static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    static final String PRE_DIGESTED_PROPERTY = "org.jboss.sasl.digest.pre_digested";
    static final String LOCAL_DEFAULT_USER = "jboss.sasl.local-user.default-user";
    static final String LOCAL_USER_CHALLENGE_PATH = "jboss.sasl.local-user.challenge-path";
    static final String ANONYMOUS = "ANONYMOUS";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String EXTERNAL = "EXTERNAL";
    static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    static final String PLAIN = "PLAIN";
    private static final String DOLLAR_LOCAL = "$local";
    private final SecurityRealm realm;
    private final CallbackHandler serverCallbackHandler;
    private final String tokensDir;

    public RealmSecurityProvider(SecurityRealm realm, CallbackHandler serverCallbackHandler, String tokensDir) {
        this.realm = realm;
        this.serverCallbackHandler = serverCallbackHandler;
        this.tokensDir = tokensDir;
    }

    @Override
    public OptionMap getOptionMap() {
        LinkedList<String> mechanisms = new LinkedList<String>();
        HashSet<Property> properties = new HashSet<Property>();
        OptionMap.Builder builder = OptionMap.builder();
        mechanisms.add(JBOSS_LOCAL_USER);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, false);
        properties.add(Property.of((String)LOCAL_DEFAULT_USER, (String)DOLLAR_LOCAL));
        if (this.tokensDir != null) {
            properties.add(Property.of((String)LOCAL_USER_CHALLENGE_PATH, (String)this.tokensDir));
        }
        if (this.digestMd5Supported()) {
            mechanisms.add(DIGEST_MD5);
            properties.add(Property.of((String)REALM_PROPERTY, (String)this.realm.getName()));
            if (RealmSecurityProvider.contains(DigestHashCallback.class, this.realm.getCallbackHandler().getSupportedCallbacks())) {
                properties.add(Property.of((String)PRE_DIGESTED_PROPERTY, (String)Boolean.TRUE.toString()));
            }
        } else if (this.plainSupported()) {
            mechanisms.add(PLAIN);
        } else if (this.realm == null) {
            mechanisms.add(ANONYMOUS);
            builder.set(Options.SASL_POLICY_NOANONYMOUS, false);
        }
        SslMode sslMode = this.getSslMode();
        switch (sslMode) {
            case OFF: {
                builder.set(Options.SSL_ENABLED, false);
                break;
            }
            case TRANSPORT_ONLY: {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
                break;
            }
            case CLIENT_AUTH_REQUESTED: {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
                mechanisms.add(0, EXTERNAL);
                builder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
            }
        }
        if (mechanisms.size() == 1) {
            throw RemotingMessages.MESSAGES.noSupportingMechanismsForRealm();
        }
        builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(mechanisms));
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(properties));
        return builder.getMap();
    }

    @Override
    public ServerAuthenticationProvider getServerAuthenticationProvider() {
        return new ServerAuthenticationProvider(){

            public AuthorizingCallbackHandler getCallbackHandler(String mechanismName) {
                final CallbackHandler cbh = RealmSecurityProvider.this.getCallbackHandler(mechanismName);
                if (cbh instanceof AuthorizingCallbackHandler) {
                    return (AuthorizingCallbackHandler)cbh;
                }
                return new AuthorizingCallbackHandler(){

                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        cbh.handle(callbacks);
                    }

                    public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) {
                        return new SimpleUserInfo(remotingPrincipals);
                    }
                };
            }
        };
    }

    @Override
    public XnioSsl getXnioSsl() {
        SSLContext sslContext;
        if (this.realm == null || (sslContext = this.realm.getSSLContext()) == null) {
            return null;
        }
        return new JsseXnioSsl(Xnio.getInstance((ClassLoader)Remoting.class.getClassLoader()), OptionMap.EMPTY, sslContext);
    }

    public CallbackHandler getCallbackHandler(String mechanismName) {
        if (ANONYMOUS.equals(mechanismName) && this.realm == null) {
            return new RealmCallbackHandler(new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    int i$ = 0;
                    Callback[] arr$ = callbacks;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        Callback current = arr$[i$];
                        throw RemotingMessages.MESSAGES.anonymousMechanismNotExpected(current);
                    }
                }
            }, null);
        }
        if (JBOSS_LOCAL_USER.equals(mechanismName)) {
            return new RealmCallbackHandler(new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            if (RealmSecurityProvider.DOLLAR_LOCAL.equals(ncb.getDefaultName())) continue;
                            throw RemotingMessages.MESSAGES.onlyLocalUserIsAcceptable(RealmSecurityProvider.DOLLAR_LOCAL);
                        }
                        if (current instanceof AuthorizeCallback) {
                            AuthorizeCallback acb = (AuthorizeCallback)current;
                            acb.setAuthorized(acb.getAuthenticationID().equals(acb.getAuthorizationID()));
                            continue;
                        }
                        throw RemotingMessages.MESSAGES.unsupportedCallback(current);
                    }
                }
            }, this.realm != null ? this.realm.getSubjectSupplemental() : null);
        }
        if (EXTERNAL.equals(mechanismName)) {
            return new RealmCallbackHandler(new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (!(current instanceof AuthorizeCallback)) {
                            throw RemotingMessages.MESSAGES.unsupportedCallback(current);
                        }
                        AuthorizeCallback acb = (AuthorizeCallback)current;
                        acb.setAuthorized(acb.getAuthenticationID().equals(acb.getAuthorizationID()));
                    }
                }
            }, this.realm.getSubjectSupplemental());
        }
        if (!(DIGEST_MD5.equals(mechanismName) && this.digestMd5Supported() || PLAIN.equals(mechanismName) && this.plainSupported())) {
            return null;
        }
        final RealmCallbackHandler realmCallbackHandler = new RealmCallbackHandler(this.realm.getCallbackHandler(), this.realm.getSubjectSupplemental());
        if (this.serverCallbackHandler == null) {
            return realmCallbackHandler;
        }
        return new AuthorizingCallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                RealmSecurityProvider.this.serverCallbackHandler.handle(callbacks);
                if (!this.handled(callbacks)) {
                    realmCallbackHandler.handle(callbacks);
                }
            }

            private boolean handled(Callback[] callbacks) {
                for (Callback current : callbacks) {
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        char[] password = pcb.getPassword();
                        return password != null && password.length > 0;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        return ((VerifyPasswordCallback)current).isVerified();
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    return ((DigestHashCallback)current).getHash() != null;
                }
                return false;
            }

            public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) throws IOException {
                return realmCallbackHandler.createUserInfo(remotingPrincipals);
            }
        };
    }

    private SslMode getSslMode() {
        if (this.realm == null || this.realm.getSSLContext() == null) {
            return SslMode.OFF;
        }
        if (this.realm.hasTrustStore()) {
            return SslMode.CLIENT_AUTH_REQUESTED;
        }
        return SslMode.TRANSPORT_ONLY;
    }

    private boolean digestMd5Supported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmSecurityProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(RealmCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(PasswordCallback.class, callbacks) && !RealmSecurityProvider.contains(DigestHashCallback.class, callbacks)) {
            return false;
        }
        return RealmSecurityProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private boolean plainSupported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmSecurityProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(VerifyPasswordCallback.class, callbacks)) {
            return false;
        }
        return RealmSecurityProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class<Callback>[] classes) {
        for (Class<Callback> current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static class RealmSubjectUserInfo
    implements SubjectUserInfo,
    UserInfo {
        private final String userName;
        private final Subject subject;

        private RealmSubjectUserInfo(Subject subject) {
            this.subject = subject;
            Set<RealmUser> userPrinc = subject.getPrincipals(RealmUser.class);
            this.userName = userPrinc.isEmpty() ? null : userPrinc.iterator().next().getName();
        }

        public String getUserName() {
            return this.userName;
        }

        public Collection<Principal> getPrincipals() {
            return this.subject.getPrincipals();
        }

        public Subject getSubject() {
            return this.subject;
        }
    }

    private class RealmCallbackHandler
    implements AuthorizingCallbackHandler {
        private final CallbackHandler callbackHandler;
        private final SubjectSupplemental subjectSupplemental;
        private final boolean subjectCallbackSupported;
        private Subject subject = null;

        private RealmCallbackHandler(CallbackHandler callbackHandler, SubjectSupplemental subjectSupplemental) {
            this.callbackHandler = callbackHandler;
            this.subjectSupplemental = subjectSupplemental;
            this.subjectCallbackSupported = false;
        }

        private RealmCallbackHandler(DomainCallbackHandler callbackHandler, SubjectSupplemental subjectSupplemental) {
            this.callbackHandler = callbackHandler;
            this.subjectSupplemental = subjectSupplemental;
            this.subjectCallbackSupported = RealmSecurityProvider.contains(SubjectCallback.class, callbackHandler.getSupportedCallbacks());
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (this.subjectCallbackSupported && callbacks.length != 1 && !(callbacks[0] instanceof AuthorizeCallback)) {
                Callback[] newCallbacks = new Callback[callbacks.length + 1];
                System.arraycopy(callbacks, 0, newCallbacks, 0, callbacks.length);
                SubjectCallback subjectCallBack = new SubjectCallback();
                newCallbacks[newCallbacks.length - 1] = subjectCallBack;
                this.callbackHandler.handle(newCallbacks);
                this.subject = subjectCallBack.getSubject();
            } else {
                this.callbackHandler.handle(callbacks);
            }
        }

        public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) throws IOException {
            Subject subject = this.subject == null ? new Subject() : this.subject;
            subject.getPrincipals().addAll(remotingPrincipals);
            Set<UserPrincipal> remotingUsers = subject.getPrincipals(UserPrincipal.class);
            HashSet<RealmUser> realmUsers = new HashSet<RealmUser>(remotingUsers.size());
            for (UserPrincipal current : remotingUsers) {
                if (RealmSecurityProvider.this.realm != null) {
                    realmUsers.add(new RealmUser(RealmSecurityProvider.this.realm.getName(), current.getName()));
                    continue;
                }
                realmUsers.add(new RealmUser(current.getName()));
            }
            subject.getPrincipals().addAll(realmUsers);
            if (this.subjectSupplemental != null) {
                this.subjectSupplemental.supplementSubject(subject);
            }
            return new RealmSubjectUserInfo(subject);
        }
    }

    private static enum SslMode {
        OFF,
        TRANSPORT_ONLY,
        CLIENT_AUTH_REQUESTED;

    }
}

