/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.File;
import java.util.HashSet;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.jboss.seam.wicket.ioc.JavassistInstrumentor;

public class WicketInstrumentationTask
extends Task {
    Path buildPath;
    private File outputDirectory;
    private FileSet fileset;
    private boolean useAnnotations = false;

    public Path getBuildPath() {
        return this.buildPath;
    }

    public void setBuildPath(Path buildPath) {
        this.buildPath = buildPath;
    }

    public void addClasspath(Path path) {
        this.buildPath = path;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void addFileset(FileSet fileset) {
        this.fileset = fileset;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public void setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
    }

    public void execute() {
        try {
            ClassPool classPool = new ClassPool();
            classPool.insertClassPath((ClassPath)new LoaderClassPath((ClassLoader)this.getProject().createClassLoader(this.buildPath)));
            JavassistInstrumentor instrumentor = new JavassistInstrumentor(classPool, this.useAnnotations);
            HashSet<String> toInstrument = new HashSet<String>();
            for (String file : this.fileset.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                if (!file.endsWith(".class")) continue;
                toInstrument.add(WicketInstrumentationTask.filenameToClassname(file));
            }
            instrumentor.instrumentClassSet(toInstrument, this.outputDirectory.getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

