/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;

public abstract class PropertyNode
implements Comparable,
Cloneable {
    protected Object _buf;
    private int _cpStart;
    private int _cpEnd;

    protected PropertyNode(int fcStart, int fcEnd, Object buf) {
        this._cpStart = fcStart;
        this._cpEnd = fcEnd;
        this._buf = buf;
        if (this._cpStart < 0) {
            System.err.println("A property claimed to start before zero, at " + this._cpStart + "! Resetting it to zero, and hoping for the best");
            this._cpStart = 0;
        }
    }

    public int getStart() {
        return this._cpStart;
    }

    public void setStart(int start) {
        this._cpStart = start;
    }

    public int getEnd() {
        return this._cpEnd;
    }

    public void setEnd(int end) {
        this._cpEnd = end;
    }

    public void adjustForDelete(int start, int length) {
        int end = start + length;
        if (this._cpEnd > start) {
            if (this._cpStart < end) {
                this._cpEnd = end >= this._cpEnd ? start : this._cpEnd - length;
                this._cpStart = Math.min(start, this._cpStart);
            } else {
                this._cpEnd -= length;
                this._cpStart -= length;
            }
        }
    }

    protected boolean limitsAreEqual(Object o) {
        return ((PropertyNode)o).getStart() == this._cpStart && ((PropertyNode)o).getEnd() == this._cpEnd;
    }

    public boolean equals(Object o) {
        if (this.limitsAreEqual(o)) {
            Object testBuf = ((PropertyNode)o)._buf;
            if (testBuf instanceof byte[] && this._buf instanceof byte[]) {
                return Arrays.equals((byte[])testBuf, (byte[])this._buf);
            }
            return this._buf.equals(testBuf);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(Object o) {
        int cpEnd = ((PropertyNode)o).getEnd();
        if (this._cpEnd == cpEnd) {
            return 0;
        }
        if (this._cpEnd < cpEnd) {
            return -1;
        }
        return 1;
    }
}

