/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.usermodel.Range;

public class HeaderStories {
    private Range headerStories;
    private PlexOfCps plcfHdd;
    private boolean stripFields = false;

    public HeaderStories(HWPFDocument doc) {
        this.headerStories = doc.getHeaderStoryRange();
        FileInformationBlock fib = doc.getFileInformationBlock();
        if (fib.getCcpHdd() == 0) {
            return;
        }
        if (fib.getPlcfHddSize() == 0) {
            return;
        }
        this.plcfHdd = new PlexOfCps(doc.getTableStream(), fib.getPlcfHddOffset(), fib.getPlcfHddSize(), 0);
    }

    public String getFootnoteSeparator() {
        return this.getAt(0);
    }

    public String getFootnoteContSeparator() {
        return this.getAt(1);
    }

    public String getFootnoteContNote() {
        return this.getAt(2);
    }

    public String getEndnoteSeparator() {
        return this.getAt(3);
    }

    public String getEndnoteContSeparator() {
        return this.getAt(4);
    }

    public String getEndnoteContNote() {
        return this.getAt(5);
    }

    public String getEvenHeader() {
        return this.getAt(6);
    }

    public String getOddHeader() {
        return this.getAt(7);
    }

    public String getFirstHeader() {
        return this.getAt(10);
    }

    public String getHeader(int pageNumber) {
        if (pageNumber == 1 && this.getFirstHeader().length() > 0) {
            return this.getFirstHeader();
        }
        if (pageNumber % 2 == 0 && this.getEvenHeader().length() > 0) {
            return this.getEvenHeader();
        }
        return this.getOddHeader();
    }

    public String getEvenFooter() {
        return this.getAt(8);
    }

    public String getOddFooter() {
        return this.getAt(9);
    }

    public String getFirstFooter() {
        return this.getAt(11);
    }

    public String getFooter(int pageNumber) {
        if (pageNumber == 1 && this.getFirstFooter().length() > 0) {
            return this.getFirstFooter();
        }
        if (pageNumber % 2 == 0 && this.getEvenFooter().length() > 0) {
            return this.getEvenFooter();
        }
        return this.getOddFooter();
    }

    private String getAt(int plcfHddIndex) {
        if (this.plcfHdd == null) {
            return null;
        }
        GenericPropertyNode prop = this.plcfHdd.getProperty(plcfHddIndex);
        if (prop.getStart() == prop.getEnd()) {
            return "";
        }
        String text = this.headerStories.text().substring(prop.getStart(), prop.getEnd());
        if (this.stripFields) {
            return Range.stripFields(text);
        }
        if (text.equals("\r\r")) {
            return "";
        }
        return text;
    }

    public Range getRange() {
        return this.headerStories;
    }

    protected PlexOfCps getPlcfHdd() {
        return this.plcfHdd;
    }

    public boolean areFieldsStripped() {
        return this.stripFields;
    }

    public void setAreFieldsStripped(boolean stripFields) {
        this.stripFields = stripFields;
    }
}

