/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AreaPtgBase;
import org.apache.poi.util.LittleEndian;

public abstract class Area2DPtgBase
extends AreaPtgBase {
    private static final int SIZE = 9;

    protected Area2DPtgBase(int firstRow, int lastRow, int firstColumn, int lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative) {
        super(firstRow, lastRow, firstColumn, lastColumn, firstRowRelative, lastRowRelative, firstColRelative, lastColRelative);
    }

    protected Area2DPtgBase(RecordInputStream in) {
        this.readCoordinates(in);
    }

    protected abstract byte getSid();

    public final void writeBytes(byte[] array, int offset) {
        LittleEndian.putByte(array, offset + 0, this.getSid() + this.getPtgClass());
        this.writeCoordinates(array, offset + 1);
    }

    public Area2DPtgBase(String arearef) {
        super(arearef);
    }

    public final int getSize() {
        return 9;
    }

    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }
}

