/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.constant.ConstantValueParser;
import org.apache.poi.hssf.record.constant.ErrorConstant;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public final class ArrayPtg
extends Ptg {
    public static final byte sid = 32;
    private static final int RESERVED_FIELD_LEN = 7;
    public static final int PLAIN_TOKEN_SIZE = 8;
    private static final byte[] DEFAULT_RESERVED_DATA = new byte[7];
    private final byte[] field_1_reserved;
    private short token_1_columns;
    private short token_2_rows;
    private Object[] token_3_arrayValues;

    public ArrayPtg(RecordInputStream in) {
        this.field_1_reserved = new byte[7];
        for (int i = 0; i < 7; ++i) {
            this.field_1_reserved[i] = in.readByte();
        }
    }

    public ArrayPtg(Object[][] values2d) {
        int nColumns = values2d[0].length;
        int nRows = values2d.length;
        this.token_1_columns = (short)nColumns;
        this.token_2_rows = (short)nRows;
        Object[] vv = new Object[this.token_1_columns * this.token_2_rows];
        for (int r = 0; r < nRows; ++r) {
            Object[] rowData = values2d[r];
            for (int c = 0; c < nColumns; ++c) {
                vv[this.getValueIndex((int)c, (int)r)] = rowData[c];
            }
        }
        this.token_3_arrayValues = vv;
        this.field_1_reserved = DEFAULT_RESERVED_DATA;
    }

    public Object[][] getTokenArrayValues() {
        if (this.token_3_arrayValues == null) {
            throw new IllegalStateException("array values not read yet");
        }
        Object[][] result = new Object[this.token_2_rows][this.token_1_columns];
        for (int r = 0; r < this.token_2_rows; ++r) {
            Object[] rowData = result[r];
            for (int c = 0; c < this.token_1_columns; ++c) {
                rowData[c] = this.token_3_arrayValues[this.getValueIndex(c, r)];
            }
        }
        return result;
    }

    public boolean isBaseToken() {
        return false;
    }

    public void readTokenValues(RecordInputStream in) {
        short nColumns = in.readUByte();
        short nRows = in.readShort();
        nColumns = (short)(nColumns + 1);
        nRows = (short)(nRows + 1);
        this.token_1_columns = nColumns;
        this.token_2_rows = nRows;
        int totalCount = nRows * nColumns;
        this.token_3_arrayValues = ConstantValueParser.parse(in, totalCount);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ArrayPtg]\n");
        sb.append("nRows = ").append(this.getRowCount()).append("\n");
        sb.append("nCols = ").append(this.getColumnCount()).append("\n");
        if (this.token_3_arrayValues == null) {
            sb.append("  #values#uninitialised#\n");
        } else {
            sb.append("  ").append(this.formatAsString());
        }
        return sb.toString();
    }

    int getValueIndex(int colIx, int rowIx) {
        if (colIx < 0 || colIx >= this.token_1_columns) {
            throw new IllegalArgumentException("Specified colIx (" + colIx + ") is outside the allowed range (0.." + (this.token_1_columns - 1) + ")");
        }
        if (rowIx < 0 || rowIx >= this.token_2_rows) {
            throw new IllegalArgumentException("Specified rowIx (" + rowIx + ") is outside the allowed range (0.." + (this.token_2_rows - 1) + ")");
        }
        return rowIx * this.token_1_columns + colIx;
    }

    public void writeBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, offset + 0, 32 + this.getPtgClass());
        System.arraycopy(this.field_1_reserved, 0, data, offset + 1, 7);
    }

    public int writeTokenValueBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, offset + 0, this.token_1_columns - 1);
        LittleEndian.putUShort(data, offset + 1, this.token_2_rows - 1);
        ConstantValueParser.encode(data, offset + 3, this.token_3_arrayValues);
        return 3 + ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public short getRowCount() {
        return this.token_2_rows;
    }

    public short getColumnCount() {
        return this.token_1_columns;
    }

    public int getSize() {
        return 11 + ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public String formatAsString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        for (int y = 0; y < this.getRowCount(); ++y) {
            if (y > 0) {
                b.append(";");
            }
            for (int x = 0; x < this.getColumnCount(); ++x) {
                if (x > 0) {
                    b.append(",");
                }
                Object o = this.token_3_arrayValues[this.getValueIndex(x, y)];
                b.append(ArrayPtg.getConstantText(o));
            }
        }
        b.append("}");
        return b.toString();
    }

    public String toFormulaString() {
        return this.formatAsString();
    }

    private static String getConstantText(Object o) {
        if (o == null) {
            throw new RuntimeException("Array item cannot be null");
        }
        if (o instanceof UnicodeString) {
            return "\"" + ((UnicodeString)o).getString() + "\"";
        }
        if (o instanceof Double) {
            return ((Double)o).toString();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "TRUE" : "FALSE";
        }
        if (o instanceof ErrorConstant) {
            return ((ErrorConstant)o).getText();
        }
        throw new IllegalArgumentException("Unexpected constant class (" + o.getClass().getName() + ")");
    }

    public byte getDefaultOperandClass() {
        return 64;
    }
}

