/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.RefPtgBase;
import org.apache.poi.util.LittleEndian;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;

    protected Ref2DPtgBase(String cellref) {
        super(cellref);
    }

    protected Ref2DPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected Ref2DPtgBase(RecordInputStream in) {
        this.readCoordinates(in);
    }

    public final void writeBytes(byte[] array, int offset) {
        LittleEndian.putByte(array, offset + 0, this.getSid() + this.getPtgClass());
        this.writeCoordinates(array, offset + 1);
    }

    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    protected abstract byte getSid();

    public final int getSize() {
        return 5;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }
}

