/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.datasource.DirectDataSourceInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;

public class DataSourceDefinitionDeploymentDescriptorParser
extends AbstractDeploymentDescriptorBindingsProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        DataSourcesMetaData dataSources = environment.getEnvironment().getDataSources();
        if (dataSources != null) {
            ArrayList<BindingConfiguration> ret = new ArrayList<BindingConfiguration>(dataSources.size());
            for (DataSourceMetaData dataSource : dataSources) {
                ret.add(this.getBindingConfiguration(dataSource));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private BindingConfiguration getBindingConfiguration(DataSourceMetaData dataSource) {
        String[] properties;
        String className;
        String name = dataSource.getName();
        if (name == null || name.isEmpty()) {
            throw EeMessages.MESSAGES.elementAttributeMissing("<data-source>", "name");
        }
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        if ((className = dataSource.getClassName()) == null || className.equals(Object.class.getName())) {
            throw EeMessages.MESSAGES.elementAttributeMissing("<data-source>", "className");
        }
        if (dataSource.getProperties() == null) {
            properties = EMPTY_STRING_ARRAY;
        } else {
            properties = new String[dataSource.getProperties().size()];
            Iterator it = dataSource.getProperties().iterator();
            for (int i = 0; i < properties.length; ++i) {
                PropertyMetaData prop = (PropertyMetaData)it.next();
                properties[i] = prop.getName() + "=" + prop.getValue();
            }
        }
        DirectDataSourceInjectionSource directDataSourceInjectionSource = new DirectDataSourceInjectionSource();
        directDataSourceInjectionSource.setClassName(className);
        directDataSourceInjectionSource.setDatabaseName(dataSource.getDatabaseName());
        if (dataSource.getDescriptions() != null) {
            directDataSourceInjectionSource.setDescription(dataSource.getDescriptions().toString());
        }
        directDataSourceInjectionSource.setInitialPoolSize(dataSource.getInitialPoolSize());
        if (dataSource.getIsolationLevel() != null) {
            directDataSourceInjectionSource.setIsolationLevel(dataSource.getIsolationLevel().ordinal());
        }
        directDataSourceInjectionSource.setLoginTimeout(dataSource.getLoginTimeout());
        directDataSourceInjectionSource.setMaxIdleTime(dataSource.getMaxIdleTime());
        directDataSourceInjectionSource.setMaxStatements(dataSource.getMaxStatements());
        directDataSourceInjectionSource.setMaxPoolSize(dataSource.getMaxPoolSize());
        directDataSourceInjectionSource.setMinPoolSize(dataSource.getMinPoolSize());
        directDataSourceInjectionSource.setPassword(dataSource.getPassword());
        directDataSourceInjectionSource.setPortNumber(dataSource.getPortNumber());
        directDataSourceInjectionSource.setProperties(properties);
        directDataSourceInjectionSource.setServerName(dataSource.getServerName());
        directDataSourceInjectionSource.setTransactional(dataSource.getTransactional());
        directDataSourceInjectionSource.setUrl(dataSource.getUrl());
        directDataSourceInjectionSource.setUser(dataSource.getUser());
        BindingConfiguration bindingDescription = new BindingConfiguration(name, directDataSourceInjectionSource);
        return bindingDescription;
    }
}

