/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class DataSourceTransactionProxyHandler
implements InvocationHandler {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry synchronizationRegistry;
    private final Object delegate;
    private final Set<Object> registeredTransactions = Collections.synchronizedSet(new HashSet());

    public DataSourceTransactionProxyHandler(Object delegate, TransactionManager transactionManager, TransactionSynchronizationRegistry synchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.delegate = delegate;
        this.synchronizationRegistry = synchronizationRegistry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getConnection") && method.getParameterTypes().length == 0 && this.delegate instanceof XADataSource) {
            XADataSource xa = (XADataSource)this.delegate;
            XAConnection xaConn = xa.getXAConnection();
            Object transactionKey = this.synchronizationRegistry.getTransactionKey();
            if (!this.registeredTransactions.contains(transactionKey) && this.transactionManager.getTransaction() != null && this.transactionActive(this.transactionManager.getTransaction().getStatus())) {
                this.transactionManager.getTransaction().enlistResource(xaConn.getXAResource());
                this.synchronizationRegistry.registerInterposedSynchronization((Synchronization)new Sync(transactionKey));
                this.registeredTransactions.add(transactionKey);
            }
            return xaConn.getConnection();
        }
        Object ret = method.invoke(this.delegate, args);
        return ret;
    }

    private boolean transactionActive(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private class Sync
    implements Synchronization {
        private final Object key;

        public Sync(Object key) {
            this.key = key;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            DataSourceTransactionProxyHandler.this.registeredTransactions.remove(this.key);
        }
    }
}

