/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnippetBuilder {
    public static final String PARAM_PREFIX = "$";
    public static final String PARAM_SUFFIX = "param";
    public static final String PARAM_STRING = "$param";
    public static final String PARAM_FORALL_STRING = "forall";
    public static final Pattern PARAM_FORALL_PATTERN = Pattern.compile("forall\\(([^{}]*)\\)\\{([^{}]+)\\}");
    private final String _template;
    private final SnippetType type;
    private final Pattern delimiter;

    public SnippetBuilder(String snippetTemplate) {
        if (snippetTemplate == null) {
            throw new RuntimeException("Script template is null - check for missing script definition.");
        }
        this._template = snippetTemplate;
        this.type = SnippetBuilder.getType(this._template);
        this.delimiter = Pattern.compile("(.*?[^\\\\])(,|\\z)");
    }

    public static SnippetType getType(String template) {
        Matcher forallMatcher = PARAM_FORALL_PATTERN.matcher(template);
        if (forallMatcher.find()) {
            return SnippetType.FORALL;
        }
        if (template.indexOf("$1") != -1) {
            return SnippetType.INDEXED;
        }
        if (template.indexOf(PARAM_STRING) != -1) {
            return SnippetType.PARAM;
        }
        return SnippetType.SINGLE;
    }

    public String build(String cellValue) {
        switch (this.type) {
            case FORALL: {
                return this.buildForAll(cellValue);
            }
            case INDEXED: {
                return this.buildMulti(cellValue);
            }
        }
        return this.buildSingle(cellValue);
    }

    private String buildForAll(String cellValue) {
        String[] cellVals = this.split(cellValue);
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher forallMatcher = PARAM_FORALL_PATTERN.matcher(this._template);
        while (forallMatcher.find()) {
            replacements.put(forallMatcher.group(), "");
            for (int paramNumber = 0; paramNumber < cellVals.length; ++paramNumber) {
                replacements.put(forallMatcher.group(), (String)replacements.get(forallMatcher.group()) + (paramNumber == 0 ? "" : " " + forallMatcher.group(1) + " ") + this.replace(forallMatcher.group(2), PARAM_PREFIX, cellVals[paramNumber].trim(), 256));
            }
        }
        String result = this._template;
        for (String key : replacements.keySet()) {
            result = this.replace(result, key, (String)replacements.get(key), 256);
        }
        return result.equals("") ? this._template : result;
    }

    private String buildMulti(String cellValue) {
        String[] cellVals = this.split(cellValue);
        String result = this._template;
        for (int paramNumber = 0; paramNumber < cellVals.length; ++paramNumber) {
            String replace = PARAM_PREFIX + (paramNumber + 1);
            result = this.replace(result, replace, cellVals[paramNumber].trim(), 256);
        }
        return result;
    }

    private String[] split(String input) {
        Matcher m = this.delimiter.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1).replaceAll("\\\\,", ","));
        }
        return result.toArray(new String[result.size()]);
    }

    private String buildSingle(String cellValue) {
        return this.replace(this._template, PARAM_STRING, cellValue, 256);
    }

    private String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || repl.equals("") || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SnippetType {
        SINGLE,
        PARAM,
        INDEXED,
        FORALL;

    }
}

