/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import java.util.logging.Logger;

public class ThreadContext {
    private static ThreadLocal<ClassLoader> previousClassloader = new ThreadLocal();
    private static Logger log = Logger.getLogger(ThreadContext.class.getName());

    public static void set(ClassLoader classLoader) {
        if (previousClassloader.get() != null) {
            log.warning("Attempting to set a new Thread Context ClassLoader without the old one being reset: " + previousClassloader.get());
        }
        previousClassloader.set(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public static void reset() {
        if (previousClassloader.get() == null) {
            log.warning("Attempting to reset the Thread Context ClassLoader without one being set");
        } else {
            Thread.currentThread().setContextClassLoader(previousClassloader.get());
            previousClassloader.set(null);
        }
    }
}

