/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;

public class Node
extends AbstractNode
implements Externalizable {
    private static final long serialVersionUID = -5040432493172658796L;
    private static Log log = LogFactory.getLog((Class)Node.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean children_loaded = false;
    private IdentityLock lock_ = null;
    private TreeCache cache;

    public Node() {
    }

    public Node(Object child_name, Fqn fqn, Node parent, Map data, TreeCache cache) {
        this.init(child_name, fqn, cache);
        if (data != null) {
            this.data().putAll(data);
        }
    }

    public Node(Object child_name, Fqn fqn, Node parent, Map data, boolean mapSafe, TreeCache cache) {
        this.init(child_name, fqn, cache);
        if (data != null) {
            if (mapSafe) {
                this.data = data;
            } else {
                this.data().putAll(data);
            }
        }
    }

    public Node(Object child_name, Fqn fqn, Node parent, Object key, Object value, TreeCache cache) {
        this.init(child_name, fqn, cache);
        this.data().put(key, value);
    }

    protected final void init(Object child_name, Fqn fqn, TreeCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("no cache init for " + fqn);
        }
        this.cache = cache;
        this.fqn = fqn;
        if (!fqn.isRoot() && !child_name.equals(fqn.getLast())) {
            throw new IllegalArgumentException("Child " + child_name + " must be last part of " + fqn);
        }
    }

    public TreeNode getParent() {
        if (this.fqn.isRoot()) {
            return null;
        }
        return this.cache.peek(this.fqn.getParent());
    }

    private synchronized void initLock() {
        if (this.lock_ == null) {
            this.lock_ = new IdentityLock(this.cache, this.fqn);
        }
    }

    protected synchronized Map children() {
        if (this.children == null) {
            this.children = this.getFqn().isRoot() ? new ConcurrentReaderHashMap(64) : new ConcurrentReaderHashMap(4);
        }
        return this.children;
    }

    private void setTreeCacheInstance(TreeCache cache) {
        this.cache = cache;
        this.lock_ = null;
    }

    public Map getChildren(boolean includeMarkedForRemoval) {
        return includeMarkedForRemoval ? this.children : this.getChildren();
    }

    public Map getChildren() {
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return this.children;
        }
        HashMap<Object, Node> toReturn = new HashMap<Object, Node>();
        Iterator c = this.children.values().iterator();
        while (c.hasNext()) {
            Node ch = (Node)c.next();
            if (ch.isMarkedForRemoval()) continue;
            toReturn.put(ch.getName(), ch);
        }
        return toReturn;
    }

    public void setRecursiveTreeCacheInstance(TreeCache cache) {
        this.setTreeCacheInstance(cache);
        if (this.children != null) {
            Iterator it = this.children.keySet().iterator();
            while (it.hasNext()) {
                DataNode nd = (DataNode)this.children.get(it.next());
                nd.setRecursiveTreeCacheInstance(cache);
            }
        }
    }

    public boolean getChildrenLoaded() {
        return this.children_loaded;
    }

    public void setChildrenLoaded(boolean flag) {
        this.children_loaded = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Node node = this;
        synchronized (node) {
            return this.data == null ? null : this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Node node = this;
        synchronized (node) {
            return this.data != null && this.data.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDataKeys() {
        Node node = this;
        synchronized (node) {
            if (this.data == null) {
                return new HashSet(0);
            }
            return this.data.keySet();
        }
    }

    boolean isReadLocked() {
        return this.lock_ != null && this.lock_.isReadLocked();
    }

    boolean isWriteLocked() {
        return this.lock_ != null && this.lock_.isWriteLocked();
    }

    public boolean isLocked() {
        return this.isWriteLocked() || this.isReadLocked();
    }

    public IdentityLock getImmutableLock() {
        this.initLock();
        return this.lock_;
    }

    public IdentityLock getLock() {
        this.initLock();
        return this.lock_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getData() {
        Node node = this;
        synchronized (node) {
            if (this.data == null) {
                return null;
            }
            return new HashMap(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numAttributes() {
        Node node = this;
        synchronized (node) {
            return this.data != null ? this.data.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Map data, boolean erase) {
        Node node = this;
        synchronized (node) {
            if (erase && this.data != null) {
                this.data.clear();
            }
            if (data == null) {
                return;
            }
            this.data().putAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Node node = this;
        synchronized (node) {
            return this.data().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        if (child_name == null) {
            throw new IllegalArgumentException("null child name");
        }
        DataNode child = (DataNode)this.children().get(child_name);
        if (createIfNotExists && child == null) {
            Fqn child_fqn = new Fqn(this.fqn, child_name);
            DataNode newChild = (DataNode)NodeFactory.getInstance().createNodeOfType(this, child_name, child_fqn, this, null, this.cache);
            if (newChild == null) {
                throw new IllegalStateException();
            }
            Node node = this;
            synchronized (node) {
                child = (Node)this.children().get(child_name);
                if (child == null) {
                    child = newChild;
                    this.children.put(child_name, child);
                    if (gtx != null) {
                        JBCMethodCall undo_op = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, new Object[]{gtx, child_fqn, Boolean.FALSE});
                        this.cache.addUndoOperation(gtx, undo_op);
                    }
                }
            }
            if (newChild == child) {
                if (trace) {
                    log.trace((Object)("created child: fqn=" + child_fqn));
                }
                this.cache.notifyNodeCreated(child.getFqn());
            }
        }
        return child;
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent) {
        return this.getOrCreateChild(child_name, null, true);
    }

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent, Object key, Object value) {
        TreeNode n = this.getOrCreateChild(child_name, null, true);
        n.put(key, value);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Node node = this;
        synchronized (node) {
            return this.data != null ? this.data.remove(key) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Node node = this;
        synchronized (node) {
            if (this.data != null) {
                this.data.clear();
                this.data = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDetails(StringBuffer sb, int indent) {
        HashMap tmp;
        Node node = this;
        synchronized (node) {
            tmp = this.data != null ? new HashMap(this.data) : null;
        }
        this.printDetailsInMap(sb, indent, tmp);
    }

    public void printLockInfo(StringBuffer sb, int indent) {
        boolean locked = this.lock_ != null && this.lock_.isLocked();
        this.printIndent(sb, indent);
        sb.append("/").append(this.getName());
        if (locked) {
            sb.append("\t(");
            this.lock_.toString(sb);
            sb.append(")");
        }
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((DataNode)it.next()).printLockInfo(sb, indent + 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nfqn=" + this.fqn);
        Node node = this;
        synchronized (node) {
            if (this.data != null) {
                if (trace) {
                    sb.append("\ndata=").append(this.data.keySet());
                } else {
                    sb.append("\ndata=[");
                    Set keys = this.data.keySet();
                    int i = 0;
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        sb.append(it.next());
                        if (++i == 5) {
                            int more = keys.size() - 5;
                            if (more <= 1) continue;
                            sb.append(", and ");
                            sb.append(more);
                            sb.append(" more");
                            break;
                        }
                        sb.append(", ");
                    }
                }
                sb.append("]");
            }
        }
        if (this.lock_ != null) {
            sb.append("\n read locked=").append(this.isReadLocked());
            sb.append("\n write locked=").append(this.isWriteLocked());
        }
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DataNode parent = (DataNode)this.getParent();
        DataNode n = (DataNode)NodeFactory.getInstance().createNodeOfType(parent, this.getName(), this.fqn, parent != null ? (DataNode)parent.clone() : null, this.data, this.cache);
        n.setChildren(this.children == null ? null : (HashMap)((HashMap)this.children).clone());
        return n;
    }

    public boolean acquire(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        try {
            if (lock_type == 0) {
                return true;
            }
            if (lock_type == 1) {
                return this.acquireReadLock(caller, timeout);
            }
            return this.acquireWriteLock(caller, timeout);
        }
        catch (UpgradeException e) {
            StringBuffer buf = new StringBuffer("failure upgrading lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new UpgradeException(buf.toString(), e);
        }
        catch (LockingException e) {
            StringBuffer buf = new StringBuffer("failure acquiring lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new LockingException(buf.toString(), e);
        }
        catch (TimeoutException e) {
            StringBuffer buf = new StringBuffer("failure acquiring lock: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new TimeoutException(buf.toString(), e);
        }
    }

    protected boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        this.initLock();
        if (trace) {
            log.trace((Object)new StringBuffer("acquiring RL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.lock_.acquireReadLock(caller, timeout);
        if (trace) {
            log.trace((Object)new StringBuffer("acquired RL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    protected boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        this.initLock();
        if (trace) {
            log.trace((Object)new StringBuffer("acquiring WL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.lock_.acquireWriteLock(caller, timeout);
        if (trace) {
            log.trace((Object)new StringBuffer("acquired WL: fqn=").append(this.fqn).append(", caller=").append(caller).append(", lock=").append(this.lock_.toString(DataNode.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        HashSet<IdentityLock> retval = new HashSet<IdentityLock>();
        if (lock_type == 0) {
            return retval;
        }
        boolean acquired = this.acquire(caller, timeout, lock_type);
        if (acquired) {
            retval.add(this.getLock());
        }
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                retval.addAll(tmp.acquireAll(caller, timeout, lock_type));
            }
        }
        return retval;
    }

    public void release(Object caller) {
        if (this.lock_ != null) {
            boolean wOwner;
            if (trace) {
                wOwner = this.lock_.isWriteLocked() && this.lock_.getWriterOwner().equals(caller);
                log.trace((Object)("releasing " + (wOwner ? "WL" : "RL") + ": fqn=" + this.fqn + ", caller=" + caller));
            }
            this.lock_.release(caller);
            if (trace) {
                wOwner = this.lock_.isWriteLocked() && this.lock_.getWriterOwner().equals(caller);
                log.trace((Object)("released " + (wOwner ? "WL" : "RL") + ": fqn=" + this.fqn + ", caller=" + caller));
            }
        }
    }

    public void releaseForce() {
        if (this.lock_ != null) {
            this.lock_.releaseForce();
        }
    }

    public void releaseAll(Object owner) {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                tmp.releaseAll(owner);
            }
        }
        this.release(owner);
    }

    public void releaseAllForce() {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                DataNode tmp = (DataNode)it.next();
                tmp.releaseAllForce();
            }
        }
        this.releaseForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getName());
        out.writeObject(this.fqn);
        out.writeObject(this.getParent());
        out.writeObject(this.children);
        Node node = this;
        synchronized (node) {
            out.writeObject(this.data);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readObject();
        this.fqn = (Fqn)in.readObject();
        in.readObject();
        this.children = (Map)in.readObject();
        this.data = (Map)in.readObject();
    }

    public void markForRemoval() {
        this.put("__JBOSS_MARKED_FOR_REMOVAL", null);
        Map children = this.getChildren(true);
        if (children != null && !children.isEmpty()) {
            Iterator i = children.values().iterator();
            while (i.hasNext()) {
                ((Node)i.next()).markForRemoval();
            }
        }
    }

    public void unmarkForRemoval(boolean deep) {
        Map children;
        this.remove("__JBOSS_MARKED_FOR_REMOVAL");
        if (deep && (children = this.getChildren(true)) != null && !children.isEmpty()) {
            Iterator i = children.values().iterator();
            while (i.hasNext()) {
                ((Node)i.next()).unmarkForRemoval(true);
            }
        }
    }

    public boolean isMarkedForRemoval() {
        return this.containsKey("__JBOSS_MARKED_FOR_REMOVAL");
    }
}

