/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionListEntry;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.EvictionQueueList;
import org.jboss.cache.eviction.NodeEntry;

public class MRUQueue
implements EvictionQueue {
    Map nodeMap = new HashMap();
    EvictionQueueList list = new EvictionQueueList();
    private int numElements = 0;

    MRUQueue() {
    }

    void moveToTopOfStack(Fqn fqn) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.remove(fqn);
        if (le != null) {
            this.list.remove(le);
            this.list.addToTop(le);
            this.nodeMap.put(le.node.getFqn(), le);
        }
    }

    public NodeEntry getFirstNodeEntry() {
        try {
            return this.list.getFirst().node;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.get(fqn);
        if (le != null) {
            return le.node;
        }
        return null;
    }

    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        return this.nodeMap.containsKey(entry.getFqn());
    }

    public void removeNodeEntry(NodeEntry entry) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.remove(entry.getFqn());
        if (le != null) {
            this.list.remove(le);
            this.numElements -= le.node.getNumberOfElements();
        }
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            entry.queue = this;
            EvictionListEntry le = new EvictionListEntry(entry);
            this.list.addToBottom(le);
            this.nodeMap.put(entry.getFqn(), le);
            this.numElements += entry.getNumberOfElements();
        }
    }

    public int getNumberOfNodes() {
        return this.list.size();
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    public void clear() {
        this.nodeMap.clear();
        this.list.clear();
        this.numElements = 0;
    }

    public Iterator iterate() {
        return this.list.iterator();
    }
}

