/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.cache.optimistic.DataVersion;

public class DefaultDataVersion
implements DataVersion,
Externalizable {
    private static final long serialVersionUID = -6896315742831861046L;
    public static final DataVersion ZERO = new DefaultDataVersion(0L);
    private static final DataVersion ONE = new DefaultDataVersion(1L);
    private static final DataVersion TWO = new DefaultDataVersion(2L);
    private long version;

    public DefaultDataVersion() {
    }

    public DefaultDataVersion(long version) {
        this.version = version;
    }

    public DataVersion increment() {
        if (this == ZERO) {
            return ONE;
        }
        if (this == ONE) {
            return TWO;
        }
        return new DefaultDataVersion(this.version + 1L);
    }

    public boolean newerThan(DataVersion other) {
        if (other instanceof DefaultDataVersion) {
            DefaultDataVersion dvOther = (DefaultDataVersion)other;
            return this.version > dvOther.version;
        }
        return false;
    }

    public String toString() {
        return "Ver=" + this.version;
    }

    public boolean equals(Object other) {
        if (other instanceof DefaultDataVersion) {
            return this.version == ((DefaultDataVersion)other).version;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.version;
    }

    public long getRawVersion() {
        return this.version;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.version);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.version = objectInput.readLong();
    }
}

