/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jgroups.util.Util;

public class StateTransferIntegrator_123
implements StateTransferIntegrator {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private byte[] transient_state;
    private byte[] persistent_state;
    private TreeCache cache;

    StateTransferIntegrator_123(byte[] state, Fqn targetFqn, TreeCache cache) {
        if (targetFqn.size() > 0) {
            throw new IllegalArgumentException("Invalid FQN " + targetFqn + " -- StateTransferVersion 123 only supports " + "transferring  FQN '/'");
        }
        this.cache = cache;
        byte[][] states = null;
        try {
            this.log.info((Object)("received the state (size=" + state.length + " bytes)"));
            states = (byte[][])Util.objectFromByteBuffer((byte[])state);
            this.transient_state = states[0];
            this.persistent_state = states[1];
            if (this.transient_state != null) {
                this.log.info((Object)("transient state: " + this.transient_state.length + " bytes"));
            }
            if (this.persistent_state != null) {
                this.log.info((Object)("persistent state: " + this.persistent_state.length + " bytes"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"failed unserializing state", t);
        }
    }

    public void integrateTransientState(DataNode target, ClassLoader cl) throws Exception {
        target.clear();
        target.removeAllChildren();
        if (this.transient_state != null) {
            try {
                this.log.info((Object)"setting transient state");
                Node new_root = (Node)Util.objectFromByteBuffer((byte[])this.transient_state);
                Map data = new_root.getData();
                target.put(data, true);
                Map children = new_root.getChildren();
                if (children != null) {
                    Iterator iter = children.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        TreeNode child = (TreeNode)entry.getValue();
                        target.addChild(entry.getKey(), child);
                    }
                }
                target.setRecursiveTreeCacheInstance(this.cache);
                if (children != null) {
                    Region[] regions;
                    RegionManager erm = this.cache.getEvictionRegionManager();
                    if (erm != null && ((regions = erm.getRegions()) == null || regions.length == 0)) {
                        erm = null;
                    }
                    if (erm != null) {
                        Iterator iter = children.values().iterator();
                        while (iter.hasNext()) {
                            this.sendEvictionNotifications((TreeNode)iter.next(), erm);
                        }
                    }
                }
                this.log.info((Object)"setting the transient state was successful");
            }
            catch (Throwable t) {
                this.log.error((Object)"failed setting transient state", t);
            }
        }
    }

    public void integratePersistentState() throws Exception {
        if (this.persistent_state != null) {
            CacheLoader cache_loader = this.cache.getCacheLoader();
            if (cache_loader == null) {
                this.log.error((Object)"cache loader is null, cannot set persistent state");
            } else {
                try {
                    this.log.info((Object)"setting the persistent state");
                    cache_loader.storeEntireState(this.persistent_state);
                    this.log.info((Object)"setting the persistent state was successful");
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed setting persistent state", t);
                }
            }
        }
    }

    private void sendEvictionNotifications(TreeNode node, RegionManager erm) {
        Map children;
        Region region;
        Fqn fqn;
        block5: {
            fqn = node.getFqn();
            region = null;
            try {
                region = erm.getRegion(fqn);
            }
            catch (RuntimeException e) {
                if (!erm.hasRegion(RegionManager.DEFAULT_REGION)) break block5;
                throw e;
            }
        }
        if (region != null) {
            Map attrs = node.getData();
            region.putNodeEvent(new EvictedEventNode(fqn, 0, attrs == null ? 0 : attrs.size()));
        }
        if ((children = node.getChildren()) != null) {
            Iterator iter = children.values().iterator();
            while (iter.hasNext()) {
                this.sendEvictionNotifications((TreeNode)iter.next(), erm);
            }
        }
    }
}

