/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.AbstractLoader;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;

public class QueryLoader
extends AbstractLoader {
    private Session session;
    private Class entityType;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Criteria criteria;
    private boolean isExplicitCriteria;
    private TimeoutManager timeoutManager;
    private ObjectsInitializer objectsInitializer;
    private boolean sizeSafe = true;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectsInitializer objectsInitializer, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
        this.objectsInitializer = objectsInitializer;
    }

    @Override
    public boolean isSizeSafe() {
        return this.sizeSafe;
    }

    public void setEntityType(Class entityType) {
        this.entityType = entityType;
    }

    @Override
    public final Object executeLoad(EntityInfo entityInfo) {
        if (this.isExplicitCriteria) {
            this.load(new EntityInfo[]{entityInfo});
        }
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    @Override
    public final List executeLoad(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.entityType == null) {
            throw new AssertionFailure("EntityType not defined");
        }
        this.objectsInitializer.initializeObjects(entityInfos, this.criteria, this.entityType, this.searchFactoryImplementor, this.timeoutManager, this.session);
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    public void setCriteria(Criteria criteria) {
        if (criteria != null) {
            this.isExplicitCriteria = true;
            this.sizeSafe = true;
            if (criteria instanceof CriteriaImpl) {
                CriteriaImpl impl = (CriteriaImpl)criteria;
                this.sizeSafe = !impl.iterateExpressionEntries().hasNext() && !impl.iterateSubcriteria().hasNext();
            }
        } else {
            this.sizeSafe = true;
            this.isExplicitCriteria = false;
        }
        this.criteria = criteria;
    }
}

