/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.jboss.netty.util.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.sonatype.aether.ant.org.jboss.netty.logging.InternalLogger;
import org.sonatype.aether.ant.org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedResourceMisuseDetector {
    private static final int MAX_ACTIVE_INSTANCES = 256;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SharedResourceMisuseDetector.class);
    private final Class<?> type;
    private final AtomicLong activeInstances = new AtomicLong();
    private final AtomicBoolean logged = new AtomicBoolean();

    public SharedResourceMisuseDetector(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
    }

    public void increase() {
        if (this.activeInstances.incrementAndGet() > 256L && this.logged.compareAndSet(false, true)) {
            logger.warn("You are creating too many " + this.type.getSimpleName() + " instances.  " + this.type.getSimpleName() + " is a shared resource that must be reused across the" + " application, so that only a few instances are created.");
        }
    }

    public void decrease() {
        this.activeInstances.decrementAndGet();
    }
}

