/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.util.Collection;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.spi.Attachments;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InvocationContextImpl
implements InvocationContext {
    private Attachments attachments;
    private BundleContext systemContext;
    private VirtualFile root;
    private Bundle bundle;

    public InvocationContextImpl(BundleContext systemContext, Bundle bundle, VirtualFile root, Attachments attachments) {
        if (systemContext == null) {
            throw new IllegalArgumentException("Null system context");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (attachments == null) {
            throw new IllegalArgumentException("Null attachments");
        }
        this.systemContext = systemContext;
        this.root = root;
        this.bundle = bundle;
        this.attachments = attachments;
    }

    @Override
    public BundleContext getSystemContext() {
        return this.systemContext;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public <T> T addAttachment(Class<T> clazz, T value) {
        return (T)this.attachments.addAttachment(clazz, value);
    }

    public <T> T addAttachment(String name, T value, Class<T> clazz) {
        return (T)this.attachments.addAttachment(name, value, clazz);
    }

    public Object addAttachment(String name, Object value) {
        return this.attachments.addAttachment(name, value);
    }

    public <T> T getAttachment(String name, Class<T> clazz) {
        return (T)this.attachments.getAttachment(name, clazz);
    }

    public <T> T getAttachment(Class<T> clazz) {
        return (T)this.attachments.getAttachment(clazz);
    }

    public Object getAttachment(String name) {
        return this.attachments.getAttachment(name);
    }

    public Collection<Attachments.Key> getAttachmentKeys() {
        return this.attachments.getAttachmentKeys();
    }

    public <T> T removeAttachment(Class<T> clazz, String name) {
        return (T)this.attachments.removeAttachment(clazz, name);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        return (T)this.attachments.removeAttachment(clazz);
    }

    public Object removeAttachment(String name) {
        return this.attachments.removeAttachment(name);
    }
}

