/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.com.sun.net.httpserver.Filter;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;

class RealmReadinessFilter
extends Filter {
    private final DomainCallbackHandler domainCBH;
    private final String redirectTo;

    RealmReadinessFilter(DomainCallbackHandler domainCBH, String redirectTo) {
        this.domainCBH = domainCBH;
        this.redirectTo = redirectTo;
    }

    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        if (this.domainCBH.isReady()) {
            chain.doFilter(exchange);
        } else {
            Headers responseHeaders = exchange.getResponseHeaders();
            responseHeaders.add("Location", this.redirectTo);
            exchange.sendResponseHeaders(307, 0L);
            exchange.close();
        }
    }

    public String description() {
        return HttpServerMessages.MESSAGES.realmReadinessFilter();
    }
}

