/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.security.AuthenticationProvider;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpsExchange;

public class ClientCertAuthenticator
extends Authenticator {
    private final AuthenticationProvider authenticationProvider;
    private final String realm;

    public ClientCertAuthenticator(AuthenticationProvider authenticationProvider, String realm) {
        this.authenticationProvider = authenticationProvider;
        this.realm = realm;
    }

    public Authenticator.Result authenticate(HttpExchange exchange) {
        HttpsExchange httpsExch;
        SSLSession session;
        Set<HttpPrincipal> httpPrincipals;
        Subject subject = (Subject)exchange.getAttribute(Subject.class.getName(), HttpExchange.AttributeScope.CONNECTION);
        if (subject != null && (httpPrincipals = subject.getPrincipals(HttpPrincipal.class)).size() > 0) {
            return new Authenticator.Success(httpPrincipals.iterator().next());
        }
        Authenticator.Failure response = null;
        if (exchange instanceof HttpsExchange && (session = (httpsExch = (HttpsExchange)exchange).getSSLSession()) != null) {
            try {
                Principal p = session.getPeerPrincipal();
                response = new Authenticator.Success(new HttpPrincipal(p.getName(), this.realm));
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        if (response != null) {
            if (response instanceof Authenticator.Success) {
                HttpPrincipal principal = ((Authenticator.Success)response).getPrincipal();
                try {
                    SubjectUserInfo userInfo = this.authenticationProvider.getCallbackHandler().createSubjectUserInfo((Principal)principal);
                    exchange.setAttribute(Subject.class.getName(), (Object)userInfo.getSubject(), HttpExchange.AttributeScope.CONNECTION);
                }
                catch (IOException e) {
                    HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                    response = new Authenticator.Failure(500);
                }
            }
        } else {
            response = new Authenticator.Failure(403);
        }
        return response;
    }
}

