/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.osgi.framework.internal.SecurityActions;

final class JDKPaths {
    static final Set<String> JDK;

    private JDKPaths() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassPathItem(String classPath, Set<String> jarSet, Set<String> pathSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    JDKPaths.processDirectory0(pathSet, file);
                } else {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        try {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                String name = entry.getName();
                                int lastSlash = name.lastIndexOf(47);
                                if (lastSlash == -1) continue;
                                pathSet.add(name.substring(0, lastSlash));
                            }
                        }
                        finally {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    private static void processDirectory0(Set<String> pathSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            pathSet.add(parent);
        }
    }

    private static void processDirectory1(Set<String> pathSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            pathSet.add(packagePath);
        }
    }

    static {
        HashSet<String> pathSet = new HashSet<String>(1024);
        HashSet<String> jarSet = new HashSet<String>(1024);
        String sunBootClassPath = SecurityActions.getSystemProperty("sun.boot.class.path", null);
        String javaClassPath = SecurityActions.getSystemProperty("java.class.path", null);
        JDKPaths.processClassPathItem(sunBootClassPath, jarSet, pathSet);
        JDKPaths.processClassPathItem(javaClassPath, jarSet, pathSet);
        JDK = pathSet;
    }
}

