/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.navigation.ConversationControl;
import org.jboss.seam.navigation.NavigationHandler;
import org.jboss.seam.navigation.Output;
import org.jboss.seam.navigation.ProcessControl;
import org.jboss.seam.navigation.TaskControl;
import org.jboss.seam.util.Strings;

public final class Rule {
    private String outcomeValue;
    private Expressions.ValueExpression condition;
    private List<Output> outputs = new ArrayList<Output>();
    private ConversationControl conversationControl = new ConversationControl();
    private TaskControl taskControl = new TaskControl();
    private ProcessControl processControl = new ProcessControl();
    private List<NavigationHandler> navigationHandlers = new ArrayList<NavigationHandler>();
    private List<String> eventTypes = new ArrayList<String>();

    public boolean matches(String actualValue) {
        return !(actualValue == null && this.condition == null || this.outcomeValue != null && !this.outcomeValue.equals(actualValue) || this.condition != null && !Boolean.TRUE.equals(this.condition.getValue()));
    }

    public List<NavigationHandler> getNavigationHandlers() {
        return this.navigationHandlers;
    }

    public void addNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandlers.add(navigationHandler);
    }

    public ConversationControl getConversationControl() {
        return this.conversationControl;
    }

    public TaskControl getTaskControl() {
        return this.taskControl;
    }

    public ProcessControl getProcessControl() {
        return this.processControl;
    }

    public Expressions.ValueExpression getCondition() {
        return this.condition;
    }

    public void setCondition(Expressions.ValueExpression expression) {
        this.condition = expression;
    }

    public String getOutcomeValue() {
        return this.outcomeValue;
    }

    public void setOutcomeValue(String value) {
        this.outcomeValue = value;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public boolean execute(FacesContext context) {
        this.getConversationControl().beginOrEndConversation();
        this.getTaskControl().beginOrEndTask();
        this.getProcessControl().createOrResumeProcess();
        for (Output output : this.getOutputs()) {
            output.out();
        }
        for (String eventType : this.eventTypes) {
            Events.instance().raiseEvent(eventType, new Object[0]);
        }
        for (NavigationHandler nh : this.getNavigationHandlers()) {
            if (!nh.navigate(context)) continue;
            return true;
        }
        return false;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public void addEventType(String eventType) {
        if (!Strings.isEmpty(eventType)) {
            this.eventTypes.add(eventType);
        }
    }
}

