/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.Synchronizations;

public class UTTransaction
extends AbstractUserTransaction {
    private static final LogProvider log = Logging.getLogProvider(UTTransaction.class);
    private final UserTransaction delegate;

    UTTransaction(UserTransaction delegate) {
        this.delegate = delegate;
        if (delegate == null) {
            throw new IllegalArgumentException("null UserTransaction");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug("beginning JTA transaction");
        this.delegate.begin();
        UTTransaction.getSynchronizations().afterTransactionBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug("committing JTA transaction");
        boolean success = false;
        Synchronizations synchronizations = UTTransaction.getSynchronizations();
        synchronizations.beforeTransactionCommit();
        try {
            this.delegate.commit();
            success = true;
        }
        finally {
            synchronizations.afterTransactionCommit(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug("rolling back JTA transaction");
        try {
            this.delegate.rollback();
        }
        finally {
            UTTransaction.getSynchronizations().afterTransactionRollback();
        }
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.delegate.setTransactionTimeout(timeout);
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        UTTransaction.getSynchronizations().registerSynchronization(sync);
    }
}

