/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.AbstractFilter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.cacheControlFilter")
@Install(value=false, precedence=0)
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.exceptionFilter"})
public class CacheControlFilter
extends AbstractFilter {
    private static final LogProvider log = Logging.getLogProvider(CacheControlFilter.class);
    private String value;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isMappedToCurrentRequestPath(request)) {
            log.debug("Applying Cache-Control HTTP header for resource '" + httpRequest.getRequestURI() + "': " + this.getValue());
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Cache-Control", this.getValue());
        }
        chain.doFilter(request, response);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

