/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.JavascriptUtils;
import org.apache.wicket.validation.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxEditableLabel<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    private FormComponent<T> editor;
    private WebComponent label;

    public AjaxEditableLabel(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public AjaxEditableLabel(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public final AjaxEditableLabel<T> add(IValidator<T> validator) {
        this.getEditor().add(validator);
        return this;
    }

    public IConverter getConverter(Class<?> type) {
        return null;
    }

    public final AjaxEditableLabel<T> setLabel(IModel<String> labelModel) {
        this.getEditor().setLabel(labelModel);
        return this;
    }

    public final AjaxEditableLabel<T> setDefaultModel(IModel<?> model) {
        super.setDefaultModel(model);
        this.getLabel().setDefaultModel(model);
        this.getEditor().setDefaultModel(model);
        return this;
    }

    public final AjaxEditableLabel<T> setRequired(boolean required) {
        this.getEditor().setRequired(required);
        return this;
    }

    public final AjaxEditableLabel<T> setType(Class<?> type) {
        this.getEditor().setType(type);
        return this;
    }

    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        TextField editor = new TextField<T>(componentId, model){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class<?> type) {
                IConverter c = AjaxEditableLabel.this.getConverter(type);
                return c != null ? c : super.getConverter(type);
            }

            protected void onModelChanged() {
                super.onModelChanged();
                AjaxEditableLabel.this.onModelChanged();
            }

            protected void onModelChanging() {
                super.onModelChanging();
                AjaxEditableLabel.this.onModelChanging();
            }
        };
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new IBehavior[]{new EditorAjaxBehavior()});
        return editor;
    }

    protected WebComponent newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        Label label = new Label(componentId, model){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class<?> type) {
                IConverter c = AjaxEditableLabel.this.getConverter(type);
                return c != null ? c : super.getConverter(type);
            }

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                Object modelObject = this.getDefaultModelObject();
                if (modelObject == null || "".equals(modelObject)) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new IBehavior[]{new LabelAjaxBehavior(this.getLabelAjaxEvent())});
        return label;
    }

    protected String getLabelAjaxEvent() {
        return "onclick";
    }

    protected final FormComponent<T> getEditor() {
        if (this.editor == null) {
            this.initLabelAndEditor(this.getParentModel());
        }
        return this.editor;
    }

    protected final WebComponent getLabel() {
        if (this.label == null) {
            this.initLabelAndEditor(this.getParentModel());
        }
        return this.label;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.editor == null) {
            this.initLabelAndEditor(this.getParentModel());
        }
    }

    protected void onCancel(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.addComponent((Component)this);
    }

    protected void onEdit(AjaxRequestTarget target) {
        this.label.setVisible(false);
        this.editor.setVisible(true);
        target.addComponent((Component)this);
        target.appendJavascript("{ var el=wicketGet('" + this.editor.getMarkupId() + "');" + "   if (el.createTextRange) { " + "     var v = el.value; var r = el.createTextRange(); " + "     r.moveStart('character', v.length); r.select(); } }");
        target.focusComponent(this.editor);
    }

    protected void onError(AjaxRequestTarget target) {
        Serializable errorMessage = this.editor.getFeedbackMessage().getMessage();
        if (errorMessage instanceof String) {
            target.appendJavascript("window.status='" + JavascriptUtils.escapeQuotes((CharSequence)((String)((Object)errorMessage))) + "';");
        }
        target.appendJavascript("{var el=wicketGet('" + this.editor.getMarkupId() + "'); el.select(); el.focus();}");
        target.addComponent(this.editor);
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.addComponent((Component)this);
        target.appendJavascript("window.status='';");
    }

    private void initLabelAndEditor(IModel<T> model) {
        this.editor = this.newEditor((MarkupContainer)this, "editor", model);
        this.label = this.newLabel((MarkupContainer)this, "label", model);
        this.add(new Component[]{this.label});
        this.add(new Component[]{this.editor});
    }

    private IModel<T> getParentModel() {
        IModel m = this.getDefaultModel();
        if (m == null) {
            MarkupContainer parent = this.getParent();
            String msg = "No model found for this component, either pass one explicitly or make sure an inheritable model is available.";
            if (parent == null) {
                msg = msg + " This component is not added to a parent yet, so if this component is supposed to use the model of the parent (e.g. when it uses a compound property model), add it first before further configuring the component calling methods like e.g. setType and addValidator.";
            }
            throw new IllegalStateException(msg);
        }
        return m;
    }

    protected String defaultNullLabel() {
        return "...";
    }

    protected void onModelChanged() {
        super.onModelChanged();
    }

    protected void onModelChanging() {
        super.onModelChanging();
    }

    protected class LabelAjaxBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public LabelAjaxBehavior(String event) {
            super(event);
        }

        protected void onEvent(AjaxRequestTarget target) {
            AjaxEditableLabel.this.onEdit(target);
        }
    }

    protected class EditorAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String saveCall = "{" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&save=true&'+this.name+'='+wicketEncode(this.value)") + "; return false;}";
            String cancelCall = "{" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&save=false'") + "; return false;}";
            String keypress = "var kc=wicketKeyCode(event); if (kc==27) " + cancelCall + " else if (kc!=13) { return true; } else " + saveCall;
            tag.put("onblur", (CharSequence)saveCall);
            tag.put("onkeypress", (CharSequence)("if (Wicket.Browser.isSafari()) { return; }; " + keypress));
            tag.put("onkeydown", (CharSequence)("if (!Wicket.Browser.isSafari()) { return; }; " + keypress));
        }

        protected void respond(AjaxRequestTarget target) {
            RequestCycle requestCycle = RequestCycle.get();
            boolean save = Boolean.valueOf(requestCycle.getRequest().getParameter("save"));
            if (save) {
                AjaxEditableLabel.this.editor.processInput();
                if (AjaxEditableLabel.this.editor.isValid()) {
                    AjaxEditableLabel.this.onSubmit(target);
                } else {
                    AjaxEditableLabel.this.onError(target);
                }
            } else {
                AjaxEditableLabel.this.onCancel(target);
            }
        }
    }
}

