/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PropagatingCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class KeepAliveTimeAttributeDefinition
extends SimpleAttributeDefinition {
    KeepAliveTimeAttributeDefinition() {
        super("keepalive-time", ModelType.OBJECT, true, (ParameterCorrector)PropagatingCorrector.INSTANCE, new ParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                if (value.getType() == ModelType.UNDEFINED) {
                    return;
                }
                if (value.getType() != ModelType.OBJECT) {
                    throw ThreadsMessages.MESSAGES.invalidKeepAliveType(parameterName, ModelType.OBJECT, value, value.getType());
                }
                Set keys = value.keys();
                if (keys.size() != 2) {
                    throw ThreadsMessages.MESSAGES.invalidKeepAliveKeys(parameterName, "time", "unit", keys);
                }
                if (!keys.contains("time")) {
                    throw ThreadsMessages.MESSAGES.missingKeepAliveTime("time", parameterName);
                }
                if (!keys.contains("unit")) {
                    throw ThreadsMessages.MESSAGES.missingKeepAliveUnit("unit", parameterName);
                }
            }

            public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
                this.validateParameter(parameterName, value);
            }
        });
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    private void addAttributeValueTypeDescription(ModelNode result, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addNoTextValueTypeDescription(result);
        result.get(new String[]{"value-type", "time", "description"}).set(resolver.getResourceAttributeValueTypeDescription("keepalive-time", locale, bundle2, new String[]{"time"}));
        result.get(new String[]{"value-type", "unit", "description"}).set(resolver.getResourceAttributeValueTypeDescription("keepalive-time", locale, bundle2, new String[]{"unit"}));
    }

    private void addOperationParameterValueTypeDescription(ModelNode result, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addNoTextValueTypeDescription(result);
        result.get(new String[]{"value-type", "time", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, "keepalive-time", locale, bundle2, new String[]{"time"}));
        result.get(new String[]{"value-type", "unit", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, "keepalive-time", locale, bundle2, new String[]{"unit"}));
    }

    private void addNoTextValueTypeDescription(ModelNode node) {
        node.get(new String[]{"value-type", "time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"value-type", "time", "required"}).set(true);
        node.get(new String[]{"value-type", "unit", "type"}).set(ModelType.STRING);
        node.get(new String[]{"value-type", "unit", "required"}).set(true);
    }
}

