/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.collections;

import java.util.Arrays;
import org.apache.lucene.util.collections.DoubleIterator;
import org.apache.lucene.util.collections.IntIterator;

public class IntToDoubleMap {
    public static final double GROUND = Double.NaN;
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    int[] keys;
    int[] next;
    private int prev;
    private int size;
    double[] values;

    public IntToDoubleMap() {
        this(defaultCapacity);
    }

    public IntToDoubleMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new double[arrayLength];
        this.keys = new int[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.values[0] = Double.NaN;
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(int key, double v) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = v;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(int key) {
        return key & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(int key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(double value) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            double d = iterator.next();
            if (d != value) continue;
            return true;
        }
        return false;
    }

    protected int find(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex] == key) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(int key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index] == key) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public double get(int key) {
        return this.values[this.find(key)];
    }

    protected void grow() {
        IntToDoubleMap that = new IntToDoubleMap(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            that.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.values = that.values;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public DoubleIterator iterator() {
        return new ValueIterator();
    }

    public IntIterator keyIterator() {
        return new KeyIterator();
    }

    private void printBaseHash() {
        for (int i = 0; i < this.baseHash.length; ++i) {
            System.out.println(i + ".\t" + this.baseHash[i]);
        }
    }

    public double put(int key, double v) {
        int index = this.find(key);
        if (index != 0) {
            double old = this.values[index];
            this.values[index] = v;
            return old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, v);
        return Double.NaN;
    }

    public double remove(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return this.values[index];
        }
        return Double.NaN;
    }

    public int size() {
        return this.size;
    }

    public double[] toArray() {
        int j = -1;
        double[] array = new double[this.size];
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public double[] toArray(double[] a) {
        int j = 0;
        if (a.length < this.size()) {
            a = new double[this.size()];
        }
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            a[j] = iterator.next();
            ++j;
        }
        if (j < a.length) {
            a[j] = Double.NaN;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        IntIterator keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            int key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        IntToDoubleMap that = (IntToDoubleMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        IntIterator it = this.keyIterator();
        while (it.hasNext()) {
            double v2;
            int key = it.next();
            if (!that.containsKey(key)) {
                return false;
            }
            double v1 = this.get(key);
            if (Double.compare(v1, v2 = that.get(key)) == 0) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements DoubleIterator {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public double next() {
            return IntToDoubleMap.this.values[this.iterator.next()];
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements IntIterator {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int next() {
            return IntToDoubleMap.this.keys[this.iterator.next()];
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < IntToDoubleMap.this.baseHash.length) {
                this.index = IntToDoubleMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        public boolean hasNext() {
            return this.index != 0;
        }

        public int next() {
            this.lastIndex = this.index;
            this.index = IntToDoubleMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < IntToDoubleMap.this.baseHash.length) {
                this.index = IntToDoubleMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        public void remove() {
            IntToDoubleMap.this.remove(IntToDoubleMap.this.keys[this.lastIndex]);
        }
    }
}

